/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableAnnotationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.annotation.display.name", new Object[0]);
        if (string == null) {
            SimplifiableAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        if (((Boolean)infos2[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.whitespace.problem.descriptor", new Object[0]);
            if (string == null) {
                SimplifiableAnnotationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("simplifiable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            SimplifiableAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new SimplifiableAnnotationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/SimplifiableAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SimplifiableAnnotationVisitor
    extends BaseInspectionVisitor {
        private SimplifiableAnnotationVisitor() {
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation2) {
            super.visitAnnotation(annotation2);
            PsiAnnotationParameterList parameterList = annotation2.getParameterList();
            PsiJavaCodeReferenceElement nameReferenceElement = annotation2.getNameReferenceElement();
            if (nameReferenceElement == null) {
                return;
            }
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiElement[] annotationChildren = annotation2.getChildren();
            if (annotationChildren.length >= 2 && annotationChildren[1] instanceof PsiWhiteSpace && !SimplifiableAnnotationVisitor.containsError(annotation2)) {
                this.registerError(annotationChildren[1], Boolean.TRUE);
            }
            if (attributes.length == 0) {
                if (parameterList.getChildren().length > 0 && !SimplifiableAnnotationVisitor.containsError(annotation2)) {
                    this.registerError((PsiElement)parameterList, ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                }
            } else if (attributes.length == 1) {
                String name;
                PsiNameValuePair attribute = attributes[0];
                PsiIdentifier identifier = attribute.getNameIdentifier();
                PsiAnnotationMemberValue attributeValue = attribute.getValue();
                if (identifier != null && attributeValue != null && "value".equals(name = attribute.getName()) && !SimplifiableAnnotationVisitor.containsError(annotation2)) {
                    this.registerErrorAtOffset((PsiElement)attribute, 0, attributeValue.getStartOffsetInParent(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                }
                if (!(attributeValue instanceof PsiArrayInitializerMemberValue)) {
                    return;
                }
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)attributeValue;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length != 1) {
                    return;
                }
                if (!SimplifiableAnnotationVisitor.containsError(annotation2)) {
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                }
            } else if (attributes.length > 1) {
                for (PsiNameValuePair attribute : attributes) {
                    PsiArrayInitializerMemberValue arrayValue;
                    PsiAnnotationMemberValue[] initializers;
                    PsiAnnotationMemberValue value = attribute.getValue();
                    if (!(value instanceof PsiArrayInitializerMemberValue) || (initializers = (arrayValue = (PsiArrayInitializerMemberValue)value).getInitializers()).length != 1 || SimplifiableAnnotationVisitor.containsError(annotation2)) continue;
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, Boolean.FALSE);
                }
            }
        }

        private static boolean containsError(PsiAnnotation annotation2) {
            PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
            if (nameRef == null) {
                return true;
            }
            PsiClass aClass2 = (PsiClass)nameRef.resolve();
            if (aClass2 == null || !aClass2.isAnnotationType()) {
                return true;
            }
            HashSet<String> names2 = new HashSet<String>();
            PsiAnnotationParameterList annotationParameterList = annotation2.getParameterList();
            if (PsiUtilCore.hasErrorElementChild(annotationParameterList)) {
                return true;
            }
            PsiNameValuePair[] attributes = annotationParameterList.getAttributes();
            for (PsiNameValuePair psiNameValuePair : attributes) {
                PsiReference reference = psiNameValuePair.getReference();
                if (reference == null) {
                    return true;
                }
                PsiMethod method = (PsiMethod)reference.resolve();
                if (method == null) {
                    return true;
                }
                PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                if (value == null || PsiUtilCore.hasErrorElementChild(value)) {
                    return true;
                }
                if (value instanceof PsiAnnotation && SimplifiableAnnotationVisitor.containsError((PsiAnnotation)value)) {
                    return true;
                }
                if (!SimplifiableAnnotationVisitor.hasCorrectType(value, method.getReturnType())) {
                    return true;
                }
                String name = psiNameValuePair.getName();
                if (names2.add(name != null ? name : "value")) continue;
                return true;
            }
            for (PsiElement psiElement : aClass2.getMethods()) {
                PsiAnnotationMethod annotationMethod;
                if (!(psiElement instanceof PsiAnnotationMethod) || (annotationMethod = (PsiAnnotationMethod)psiElement).getDefaultValue() != null || names2.contains(annotationMethod.getName())) continue;
                return true;
            }
            return false;
        }

        private static boolean hasCorrectType(@Nullable PsiAnnotationMemberValue value, PsiType expectedType2) {
            if (value == null) {
                return false;
            }
            if (expectedType2 instanceof PsiClassType && expectedType2.equalsToText("java.lang.Class") && !(value instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            if (value instanceof PsiAnnotation) {
                PsiClass aClass2;
                PsiType componentType;
                PsiClass aClass3;
                PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value).getNameReferenceElement();
                if (nameRef == null) {
                    return true;
                }
                if (expectedType2 instanceof PsiClassType && (aClass3 = ((PsiClassType)expectedType2).resolve()) != null && nameRef.isReferenceTo(aClass3)) {
                    return true;
                }
                return expectedType2 instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType2).getComponentType()) instanceof PsiClassType && (aClass2 = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo(aClass2);
            }
            if (value instanceof PsiArrayInitializerMemberValue) {
                return expectedType2 instanceof PsiArrayType;
            }
            if (value instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)value;
                return expression2.getType() != null && TypeConversionUtil.areTypesAssignmentCompatible(expectedType2, expression2) || expectedType2 instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible(((PsiArrayType)expectedType2).getComponentType(), expression2);
            }
            return true;
        }
    }

    private static class SimplifiableAnnotationFix
    extends InspectionGadgetsFix {
        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiAnnotation annotation2 = PsiTreeUtil.getParentOfType(element, PsiAnnotation.class);
            if (annotation2 == null) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            String annotationText = SimplifiableAnnotationFix.buildAnnotationText(annotation2);
            PsiAnnotation newAnnotation = factory2.createAnnotationFromText(annotationText, element);
            annotation2.replace(newAnnotation);
        }

        private static String buildAnnotationText(PsiAnnotation annotation2) {
            StringBuilder out = new StringBuilder("@");
            PsiJavaCodeReferenceElement nameReferenceElement = annotation2.getNameReferenceElement();
            assert (nameReferenceElement != null);
            out.append(nameReferenceElement.getText());
            PsiAnnotationParameterList parameterList = annotation2.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            if (attributes.length == 0) {
                return out.toString();
            }
            out.append('(');
            if (attributes.length == 1) {
                PsiNameValuePair attribute = attributes[0];
                String name = attribute.getName();
                if (name != null && !"value".equals(name)) {
                    out.append(name).append('=');
                }
                SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out);
            } else {
                for (int i = 0; i < attributes.length; ++i) {
                    PsiNameValuePair attribute = attributes[i];
                    if (i > 0) {
                        out.append(',');
                    }
                    out.append(attribute.getName()).append('=');
                    SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out);
                }
            }
            out.append(')');
            return out.toString();
        }

        private static StringBuilder buildAttributeValueText(PsiAnnotationMemberValue value, StringBuilder out) {
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)value;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length == 1) {
                    return out.append(initializers[0].getText());
                }
            } else if (value instanceof PsiAnnotation) {
                return out.append(SimplifiableAnnotationFix.buildAnnotationText((PsiAnnotation)value));
            }
            return out.append(value.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationFix", "getFamilyName"));
        }
    }
}

