/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryQualifierForThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message(infos2[0] instanceof PsiThisExpression ? "unnecessary.qualifier.for.this.problem.descriptor" : "unnecessary.qualifier.for.super.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryQualifierForThisInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        @Override
        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                UnnecessaryQualifierForThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(thisExpression);
            if (containingClass == null || !containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, thisExpression);
        }

        @Override
        public void visitSuperExpression(PsiSuperExpression expression2) {
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement resolve2 = qualifier.resolve();
            if (!(resolve2 instanceof PsiClass)) {
                return;
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiReferenceExpression) {
                PsiElement gParent = parent2.getParent();
                PsiReferenceExpression copy = gParent instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)gParent.copy()).getMethodExpression() : (PsiReferenceExpression)parent2.copy();
                PsiExpression copyQualifierExpression = copy.getQualifierExpression();
                assert (copyQualifierExpression != null);
                PsiReplacementUtil.replaceExpression(copyQualifierExpression, "super");
                if (copy.resolve() == ((PsiReferenceExpression)parent2).resolve()) {
                    this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, expression2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisExpression", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor", "visitThisExpression"));
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryQualifierForThisFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement qualifier = descriptor2.getPsiElement();
            PsiElement parent2 = qualifier.getParent();
            if (parent2 instanceof PsiThisExpression) {
                PsiReplacementUtil.replaceExpression((PsiThisExpression)parent2, "this");
            } else if (parent2 instanceof PsiSuperExpression) {
                PsiReplacementUtil.replaceExpression((PsiSuperExpression)parent2, "super");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix", "getFamilyName"));
        }
    }
}

