/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AtomicFieldUpdaterIssuesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("atomic.field.updater.issues.display.name", new Object[0]);
        if (string == null) {
            AtomicFieldUpdaterIssuesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = (String)infos2[0];
        if (string == null) {
            AtomicFieldUpdaterIssuesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AtomicFieldUpdaterIssuesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/AtomicFieldUpdaterIssuesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AtomicFieldUpdaterIssuesVisitor
    extends BaseInspectionVisitor {
        private AtomicFieldUpdaterIssuesVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"newUpdater".equals(name)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length < 2) {
                return;
            }
            PsiExpression lastArgument = arguments2[arguments2.length - 1];
            Object value = ExpressionUtils.computeConstantExpression(lastArgument);
            if (!(value instanceof String)) {
                return;
            }
            String fieldName = (String)value;
            PsiExpression firstArgument = ParenthesesUtils.stripParentheses(arguments2[0]);
            if (!(firstArgument instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)firstArgument;
            PsiType operandType = classObjectAccessExpression.getOperand().getType();
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClass target = classType.resolve();
            if (target == null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            String typeString = TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.concurrent.atomic.AtomicLongFieldUpdater", "java.util.concurrent.atomic.AtomicIntegerFieldUpdater", "java.util.concurrent.atomic.AtomicReferenceFieldUpdater");
            if (typeString == null) {
                return;
            }
            PsiField field = target.findFieldByName(fieldName, false);
            if (field == null) {
                this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.not.found.in.class.problem.descriptor", fieldName, target.getName()));
                return;
            }
            if (typeString.equals("java.util.concurrent.atomic.AtomicLongFieldUpdater")) {
                if (arguments2.length != 2) {
                    return;
                }
                if (!PsiType.LONG.equals(field.getType())) {
                    this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.incorrect.type.problem.descriptor", fieldName, "long"));
                    return;
                }
            } else if (typeString.equals("java.util.concurrent.atomic.AtomicIntegerFieldUpdater")) {
                if (arguments2.length != 2) {
                    return;
                }
                if (!PsiType.INT.equals(field.getType())) {
                    this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.incorrect.type.problem.descriptor", fieldName, "int"));
                    return;
                }
            } else if (typeString.equals("java.util.concurrent.atomic.AtomicReferenceFieldUpdater")) {
                if (arguments2.length != 3) {
                    return;
                }
                PsiExpression argument2 = arguments2[1];
                if (!(argument2 instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression objectAccessExpression = (PsiClassObjectAccessExpression)argument2;
                PsiType type2 = objectAccessExpression.getOperand().getType();
                PsiType substFieldType = classType.resolveGenerics().getSubstitutor().substitute(field.getType());
                if (substFieldType == null) {
                    return;
                }
                if (!substFieldType.isAssignableFrom(type2)) {
                    this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.incorrect.type.problem.descriptor", fieldName, type2.getPresentableText()));
                    return;
                }
            } else assert (false);
            if (!field.hasModifierProperty("volatile")) {
                this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.missing.volatile.modifier.problem.descriptor", fieldName));
            } else if (field.hasModifierProperty("static")) {
                this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("field.has.static.modifier.problem.descriptor", fieldName));
            } else if (!field.hasModifierProperty("public")) {
                if (ClassUtils.getContainingClass(expression2) != field.getContainingClass()) {
                    if (field.hasModifierProperty("private")) {
                        this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("private.field.not.accessible.problem.descriptor", fieldName));
                    }
                } else if (!ClassUtils.inSamePackage(expression2, field)) {
                    if (field.hasModifierProperty("packageLocal")) {
                        this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("package.local.field.not.accessible", fieldName));
                    }
                } else {
                    PsiClass expressionClass = ClassUtils.getContainingClass(expression2);
                    PsiClass fieldClass = field.getContainingClass();
                    if (expressionClass != null && fieldClass != null && !expressionClass.isInheritor(fieldClass, true) && field.hasModifierProperty("protected")) {
                        this.registerError((PsiElement)lastArgument, InspectionGadgetsBundle.message("protected.field.not.accessible.problem.descriptor", fieldName));
                    }
                }
            }
        }
    }
}

