/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ObjectNotifyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("CallToNotifyInsteadOfNotifyAll" == null) {
            ObjectNotifyInspection.$$$reportNull$$$0(0);
        }
        return "CallToNotifyInsteadOfNotifyAll";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.notify.display.name", new Object[0]);
        if (string == null) {
            ObjectNotifyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("object.notify.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectNotifyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectNotifyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ObjectNotifyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/ObjectNotifyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectNotifyVisitor
    extends BaseInspectionVisitor {
        private ObjectNotifyVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ObjectNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            if (argumentList2.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ObjectNotifyInspection$ObjectNotifyVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ObjectNotifyFix
    extends InspectionGadgetsFix {
        private ObjectNotifyFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("object.notify.replace.quickfix", new Object[0]);
            if (string == null) {
                ObjectNotifyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor2.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            assert (methodExpression != null);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression(methodExpression, "notifyAll");
            } else {
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression(methodExpression, qualifierText + '.' + "notifyAll");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ObjectNotifyInspection$ObjectNotifyFix", "getFamilyName"));
        }
    }
}

