/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class AnonymousClassVariableHidesOuterClassVariableVisitor
extends BaseInspectionVisitor {
    AnonymousClassVariableHidesOuterClassVariableVisitor() {
    }

    @Override
    public void visitAnonymousClass(PsiAnonymousClass aClass2) {
        PsiParameter[] parameters2;
        super.visitAnonymousClass(aClass2);
        PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiCodeBlock.class);
        if (codeBlock == null) {
            return;
        }
        VariableCollector collector2 = new VariableCollector();
        aClass2.acceptChildren(collector2);
        PsiStatement[] statements = codeBlock.getStatements();
        int offset2 = aClass2.getTextOffset();
        for (PsiStatement statement2 : statements) {
            PsiElement[] declaredElements;
            if (statement2.getTextOffset() >= offset2) break;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                PsiVariable[] variables;
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                String name = localVariable.getName();
                for (PsiVariable variable2 : variables = collector2.getVariables(name)) {
                    this.registerVariableError(variable2, variable2);
                }
            }
        }
        Object containingMethod = PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiMethod.class, PsiLambdaExpression.class);
        if (containingMethod == null) {
            return;
        }
        PsiParameterList parameterList = containingMethod instanceof PsiMethod ? ((PsiMethod)containingMethod).getParameterList() : ((PsiLambdaExpression)containingMethod).getParameterList();
        for (PsiParameter parameter : parameters2 = parameterList.getParameters()) {
            PsiVariable[] variables;
            String name = parameter.getName();
            for (PsiVariable variable3 : variables = collector2.getVariables(name)) {
                this.registerVariableError(variable3, variable3);
            }
        }
    }

    private static class VariableCollector
    extends JavaRecursiveElementWalkingVisitor {
        private static final PsiVariable[] EMPTY_VARIABLE_LIST = new PsiVariable[0];
        private final Map<String, List<PsiVariable>> variableMap = new HashMap<String, List<PsiVariable>>();

        private VariableCollector() {
        }

        @Override
        public void visitVariable(PsiVariable variable2) {
            super.visitVariable(variable2);
            String name = variable2.getName();
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                ArrayList<PsiVariable> list2 = new ArrayList<PsiVariable>();
                list2.add(variable2);
                this.variableMap.put(name, list2);
            } else {
                variableList.add(variable2);
            }
        }

        @Override
        public void visitClass(PsiClass aClass2) {
        }

        @NotNull
        public PsiVariable[] getVariables(String name) {
            List<PsiVariable> variableList = this.variableMap.get(name);
            if (variableList == null) {
                if (EMPTY_VARIABLE_LIST == null) {
                    VariableCollector.$$$reportNull$$$0(0);
                }
                return EMPTY_VARIABLE_LIST;
            }
            PsiVariable[] psiVariableArray = variableList.toArray(new PsiVariable[variableList.size()]);
            if (psiVariableArray == null) {
                VariableCollector.$$$reportNull$$$0(1);
            }
            return psiVariableArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AnonymousClassVariableHidesOuterClassVariableVisitor$VariableCollector", "getVariables"));
        }
    }
}

