/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("MethodOverridesStaticMethodOfSuperclass" == null) {
            MethodOverridesStaticMethodInspectionBase.$$$reportNull$$$0(0);
        }
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overrides.static.display.name", new Object[0]);
        if (string == null) {
            MethodOverridesStaticMethodInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodOverridesStaticMethodInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass2;
            if (method == null) {
                MethodOverridesStaticMethodVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass2 = method.getContainingClass()) == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            String methodName = method.getName();
            MethodSignature signature2 = method.getSignature(PsiSubstitutor.EMPTY);
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass2.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                PsiMethod[] methods2;
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                for (PsiMethod testMethod : methods2 = ancestorClass.findMethodsByName(methodName, false)) {
                    MethodSignature testSignature = testMethod.getSignature(PsiSubstitutor.EMPTY);
                    if (!signature2.equals(testSignature) || !testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                    this.registerMethodError(method, new Object[0]);
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/visibility/MethodOverridesStaticMethodInspectionBase$MethodOverridesStaticMethodVisitor", "visitMethod"));
        }
    }
}

