/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethodParametersHidingInstanceFields = true;
    public boolean m_ignoreForConstructors = false;
    public boolean m_ignoreForPropertySetters = false;
    public boolean m_ignoreForAbstractMethods = false;

    @Override
    @NotNull
    public String getID() {
        if ("ParameterHidesMemberVariable" == null) {
            ParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return "ParameterHidesMemberVariable";
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "hiding";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            ParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        String string = InspectionGadgetsBundle.message("parameter.hides.member.variable.problem.descriptor", aClass2.getName());
        if (string == null) {
            ParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.setters.option", new Object[0]), "m_ignoreForPropertySetters");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.superclass.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.constructors.option", new Object[0]), "m_ignoreForConstructors");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.abstract.methods.option", new Object[0]), "m_ignoreForAbstractMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.hides.member.variable.ignore.static.parameters.option", new Object[0]), "m_ignoreStaticMethodParametersHidingInstanceFields");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/ParameterHidingMemberVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private ParameterHidingMemberVariableVisitor() {
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable2) {
            PsiClass aClass2;
            if (variable2 == null) {
                ParameterHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(variable2);
            PsiElement declarationScope = variable2.getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)declarationScope;
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForConstructors && method.isConstructor()) {
                return;
            }
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForAbstractMethods) {
                if (method.hasModifierProperty("abstract")) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && containingClass.isInterface()) {
                    return;
                }
            }
            if (ParameterHidingMemberVariableInspectionBase.this.m_ignoreForPropertySetters) {
                String methodName = method.getName();
                if (methodName.startsWith("set") && PsiType.VOID.equals(method.getReturnType())) {
                    return;
                }
                if (PropertyUtilBase.isSimplePropertySetter(method)) {
                    return;
                }
            }
            if ((aClass2 = this.checkFieldName(variable2, method)) == null) {
                return;
            }
            this.registerVariableError(variable2, aClass2);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable2, PsiMethod method) {
            String variableName = variable2.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass2 = ClassUtils.getContainingClass(method);
            while (aClass2 != null) {
                PsiField field = aClass2.findFieldByName(variableName, true);
                if (!(field == null || ParameterHidingMemberVariableInspectionBase.this.m_ignoreStaticMethodParametersHidingInstanceFields && !field.hasModifierProperty("static") && method.hasModifierProperty("static") || ParameterHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass2))) {
                    return aClass2;
                }
                if (aClass2.hasModifierProperty("static") && ParameterHidingMemberVariableInspectionBase.this.m_ignoreStaticMethodParametersHidingInstanceFields) {
                    return null;
                }
                aClass2 = ClassUtils.getContainingClass(aClass2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/ParameterHidingMemberVariableInspectionBase$ParameterHidingMemberVariableVisitor", "visitParameter"));
        }
    }
}

