/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsLoader;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsPackageFragment;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.AdditionalClassPartsProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.ClassDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.PlatformDependentDeclarationFilter;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageFragmentDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KotlinBuiltIns {
    public static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("kotlin");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    private static final FqName ANNOTATION_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
    public static final FqName RANGES_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
    public static final FqName TEXT_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf(new FqName[]{BUILT_INS_PACKAGE_FQ_NAME, COLLECTIONS_PACKAGE_FQ_NAME, RANGES_PACKAGE_FQ_NAME, ANNOTATION_PACKAGE_FQ_NAME, ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME(), BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"))});
    private ModuleDescriptorImpl builtInsModule;
    private final NotNullLazyValue<Primitives> primitives;
    private final NotNullLazyValue<PackageFragments> packageFragments;
    private final MemoizedFunctionToNotNull<Integer, ClassDescriptor> suspendFunctionClasses;
    private final MemoizedFunctionToNotNull<Name, ClassDescriptor> builtInClassesByName;
    private final StorageManager storageManager;
    public static final FqNames FQ_NAMES = new FqNames();
    public static final Name BUILTINS_MODULE_NAME = Name.special("<built-ins module>");

    protected KotlinBuiltIns(@NotNull StorageManager storageManager) {
        this.storageManager = storageManager;
        this.packageFragments = storageManager.createLazyValue(new Function0<PackageFragments>(){

            @Override
            public PackageFragments invoke() {
                PackageFragmentProvider provider = KotlinBuiltIns.this.builtInsModule.getPackageFragmentProvider();
                LinkedHashMap nameToFragment = new LinkedHashMap();
                PackageFragmentDescriptor kotlin = KotlinBuiltIns.this.createPackage(provider, nameToFragment, BUILT_INS_PACKAGE_FQ_NAME);
                PackageFragmentDescriptor kotlinCollections = KotlinBuiltIns.this.createPackage(provider, nameToFragment, COLLECTIONS_PACKAGE_FQ_NAME);
                KotlinBuiltIns.this.createPackage(provider, nameToFragment, RANGES_PACKAGE_FQ_NAME);
                PackageFragmentDescriptor kotlinAnnotation = KotlinBuiltIns.this.createPackage(provider, nameToFragment, ANNOTATION_PACKAGE_FQ_NAME);
                LinkedHashSet allImportedByDefault = new LinkedHashSet(nameToFragment.values());
                return new PackageFragments(kotlin, kotlinCollections, kotlinAnnotation, allImportedByDefault);
            }
        });
        this.primitives = storageManager.createLazyValue(new Function0<Primitives>(){

            @Override
            public Primitives invoke() {
                EnumMap<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType = new EnumMap<PrimitiveType, SimpleType>(PrimitiveType.class);
                HashMap<SimpleType, SimpleType> primitiveKotlinTypeToKotlinArrayType = new HashMap<SimpleType, SimpleType>();
                HashMap<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType = new HashMap<SimpleType, SimpleType>();
                for (PrimitiveType primitive : PrimitiveType.values()) {
                    SimpleType type2 = KotlinBuiltIns.this.getBuiltInTypeByClassName(primitive.getTypeName().asString());
                    SimpleType arrayType = KotlinBuiltIns.this.getBuiltInTypeByClassName(primitive.getArrayTypeName().asString());
                    primitiveTypeToArrayKotlinType.put(primitive, arrayType);
                    primitiveKotlinTypeToKotlinArrayType.put(type2, arrayType);
                    kotlinArrayTypeToPrimitiveKotlinType.put(arrayType, type2);
                }
                return new Primitives(primitiveTypeToArrayKotlinType, primitiveKotlinTypeToKotlinArrayType, kotlinArrayTypeToPrimitiveKotlinType);
            }
        });
        this.suspendFunctionClasses = storageManager.createMemoizedFunction(new Function1<Integer, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(Integer arity) {
                return new FunctionClassDescriptor(KotlinBuiltIns.this.getStorageManager(), ((PackageFragments)((KotlinBuiltIns)KotlinBuiltIns.this).packageFragments.invoke()).builtInsPackageFragment, FunctionClassDescriptor.Kind.SuspendFunction, arity);
            }
        });
        this.builtInClassesByName = storageManager.createMemoizedFunction(new Function1<Name, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(Name name) {
                return KotlinBuiltIns.getBuiltInClassByName(name, KotlinBuiltIns.this.getBuiltInsPackageFragment());
            }
        });
    }

    protected void createBuiltInsModule() {
        this.builtInsModule = new ModuleDescriptorImpl(BUILTINS_MODULE_NAME, this.storageManager, this, null);
        this.builtInsModule.initialize(BuiltInsLoader.Companion.getInstance().createPackageFragmentProvider(this.storageManager, this.builtInsModule, this.getClassDescriptorFactories(), this.getPlatformDependentDeclarationFilter(), this.getAdditionalClassPartsProvider()));
        this.builtInsModule.setDependencies(this.builtInsModule);
    }

    @NotNull
    protected AdditionalClassPartsProvider getAdditionalClassPartsProvider() {
        return AdditionalClassPartsProvider.None.INSTANCE;
    }

    @NotNull
    protected PlatformDependentDeclarationFilter getPlatformDependentDeclarationFilter() {
        return PlatformDependentDeclarationFilter.NoPlatformDependent.INSTANCE;
    }

    @NotNull
    protected Iterable<ClassDescriptorFactory> getClassDescriptorFactories() {
        return Collections.singletonList(new BuiltInFictitiousFunctionClassFactory(this.storageManager, this.builtInsModule));
    }

    @NotNull
    private PackageFragmentDescriptor createPackage(@NotNull PackageFragmentProvider fragmentProvider, @Nullable Map<FqName, PackageFragmentDescriptor> packageNameToPackageFragment, final @NotNull FqName packageFqName) {
        PackageFragmentDescriptorImpl result2;
        final List<PackageFragmentDescriptor> packageFragments2 = fragmentProvider.getPackageFragments(packageFqName);
        PackageFragmentDescriptor packageFragmentDescriptor = packageFragments2.isEmpty() ? new EmptyPackageFragmentDescriptor(this.builtInsModule, packageFqName) : (result2 = packageFragments2.size() == 1 ? packageFragments2.iterator().next() : new PackageFragmentDescriptorImpl(this.builtInsModule, packageFqName){

            @Override
            @NotNull
            public MemberScope getMemberScope() {
                return new ChainedMemberScope("built-in package " + packageFqName, CollectionsKt.map(packageFragments2, new Function1<PackageFragmentDescriptor, MemberScope>(){

                    @Override
                    public MemberScope invoke(PackageFragmentDescriptor descriptor2) {
                        return descriptor2.getMemberScope();
                    }
                }));
            }
        });
        if (packageNameToPackageFragment != null) {
            packageNameToPackageFragment.put(packageFqName, result2);
        }
        return result2;
    }

    @NotNull
    protected StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        return this.builtInsModule;
    }

    @NotNull
    public PackageFragmentDescriptor getBuiltInsPackageFragment() {
        return ((PackageFragments)this.packageFragments.invoke()).builtInsPackageFragment;
    }

    public static boolean isBuiltIn(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.getParentOfType(descriptor2, BuiltInsPackageFragment.class, false) != null;
    }

    public static boolean isUnderKotlinPackage(@NotNull DeclarationDescriptor descriptor2) {
        for (DeclarationDescriptor current = descriptor2; current != null; current = current.getContainingDeclaration()) {
            if (!(current instanceof PackageFragmentDescriptor)) continue;
            return ((PackageFragmentDescriptor)current).getFqName().startsWith(BUILT_INS_PACKAGE_NAME);
        }
        return false;
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName2) {
        return (ClassDescriptor)this.builtInClassesByName.invoke(simpleName2);
    }

    @NotNull
    private static ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName2, @NotNull PackageFragmentDescriptor packageFragment) {
        ClassDescriptor classDescriptor = KotlinBuiltIns.getBuiltInClassByNameNullable(simpleName2, packageFragment);
        if (classDescriptor == null) {
            throw new AssertionError((Object)("Built-in class " + packageFragment.getFqName().child(simpleName2).asString() + " is not found"));
        }
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor getBuiltInClassByFqNameNullable(@NotNull FqName fqName2) {
        return DescriptorUtilKt.resolveClassByFqName(this.builtInsModule, fqName2, NoLookupLocation.FROM_BUILTINS);
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByFqName(@NotNull FqName fqName2) {
        ClassDescriptor descriptor2 = this.getBuiltInClassByFqNameNullable(fqName2);
        assert (descriptor2 != null) : "Can't find built-in class " + fqName2;
        return descriptor2;
    }

    @Nullable
    private static ClassDescriptor getBuiltInClassByNameNullable(@NotNull Name simpleName2, @NotNull PackageFragmentDescriptor packageFragment) {
        ClassifierDescriptor classifier2 = packageFragment.getMemberScope().getContributedClassifier(simpleName2, NoLookupLocation.FROM_BUILTINS);
        assert (classifier2 == null || classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName2 + ", but was " + classifier2;
        return (ClassDescriptor)classifier2;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName2) {
        return this.getBuiltInClassByName(Name.identifier(simpleName2));
    }

    @NotNull
    private static ClassDescriptor getBuiltInClassByName(@NotNull String simpleName2, PackageFragmentDescriptor packageFragment) {
        return KotlinBuiltIns.getBuiltInClassByName(Name.identifier(simpleName2), packageFragment);
    }

    @NotNull
    public ClassDescriptor getAny() {
        return this.getBuiltInClassByName("Any");
    }

    @NotNull
    public ClassDescriptor getNothing() {
        return this.getBuiltInClassByName("Nothing");
    }

    @NotNull
    private ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type2) {
        return this.getBuiltInClassByName(type2.getTypeName().asString());
    }

    @NotNull
    public ClassDescriptor getArray() {
        return this.getBuiltInClassByName("Array");
    }

    @NotNull
    public ClassDescriptor getNumber() {
        return this.getBuiltInClassByName("Number");
    }

    @NotNull
    public ClassDescriptor getUnit() {
        return this.getBuiltInClassByName("Unit");
    }

    @NotNull
    public static String getFunctionName(int parameterCount) {
        return "Function" + parameterCount;
    }

    @NotNull
    public static ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(KotlinBuiltIns.getFunctionName(parameterCount)));
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        return this.getBuiltInClassByName(KotlinBuiltIns.getFunctionName(parameterCount));
    }

    @NotNull
    public ClassDescriptor getSuspendFunction(int parameterCount) {
        return (ClassDescriptor)this.suspendFunctionClasses.invoke(parameterCount);
    }

    @NotNull
    public ClassDescriptor getString() {
        return this.getBuiltInClassByName("String");
    }

    @NotNull
    private ClassDescriptor getCollectionClassByName(@NotNull String simpleName2) {
        return KotlinBuiltIns.getBuiltInClassByName(simpleName2, ((PackageFragments)this.packageFragments.invoke()).collectionsPackageFragment);
    }

    @NotNull
    public ClassDescriptor getCollection() {
        return this.getCollectionClassByName("Collection");
    }

    @NotNull
    private SimpleType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        return this.getBuiltInClassByName(classSimpleName).getDefaultType();
    }

    @NotNull
    public SimpleType getNothingType() {
        return this.getNothing().getDefaultType();
    }

    @NotNull
    public SimpleType getNullableNothingType() {
        return this.getNothingType().makeNullableAsSpecified(true);
    }

    @NotNull
    public SimpleType getAnyType() {
        return this.getAny().getDefaultType();
    }

    @NotNull
    public SimpleType getNullableAnyType() {
        return this.getAnyType().makeNullableAsSpecified(true);
    }

    @NotNull
    public SimpleType getDefaultBound() {
        return this.getNullableAnyType();
    }

    @NotNull
    public SimpleType getPrimitiveKotlinType(@NotNull PrimitiveType type2) {
        return this.getPrimitiveClassDescriptor(type2).getDefaultType();
    }

    @NotNull
    public SimpleType getByteType() {
        return this.getPrimitiveKotlinType(PrimitiveType.BYTE);
    }

    @NotNull
    public SimpleType getShortType() {
        return this.getPrimitiveKotlinType(PrimitiveType.SHORT);
    }

    @NotNull
    public SimpleType getIntType() {
        return this.getPrimitiveKotlinType(PrimitiveType.INT);
    }

    @NotNull
    public SimpleType getLongType() {
        return this.getPrimitiveKotlinType(PrimitiveType.LONG);
    }

    @NotNull
    public SimpleType getFloatType() {
        return this.getPrimitiveKotlinType(PrimitiveType.FLOAT);
    }

    @NotNull
    public SimpleType getDoubleType() {
        return this.getPrimitiveKotlinType(PrimitiveType.DOUBLE);
    }

    @NotNull
    public SimpleType getCharType() {
        return this.getPrimitiveKotlinType(PrimitiveType.CHAR);
    }

    @NotNull
    public SimpleType getBooleanType() {
        return this.getPrimitiveKotlinType(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public SimpleType getUnitType() {
        return this.getUnit().getDefaultType();
    }

    @NotNull
    public SimpleType getStringType() {
        return this.getString().getDefaultType();
    }

    @NotNull
    public KotlinType getArrayElementType(@NotNull KotlinType arrayType) {
        if (KotlinBuiltIns.isArray(arrayType)) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            return arrayType.getArguments().get(0).getType();
        }
        KotlinType primitiveType = ((Primitives)this.primitives.invoke()).kotlinArrayTypeToPrimitiveKotlinType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        return primitiveType;
    }

    @NotNull
    public SimpleType getPrimitiveArrayKotlinType(@NotNull PrimitiveType primitiveType) {
        return ((Primitives)this.primitives.invoke()).primitiveTypeToArrayKotlinType.get((Object)primitiveType);
    }

    @Nullable
    public SimpleType getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(@NotNull KotlinType kotlinType) {
        return ((Primitives)this.primitives.invoke()).primitiveKotlinTypeToKotlinArrayType.get(kotlinType);
    }

    public static boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        return KotlinBuiltIns.FQ_NAMES.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @Nullable
    public static PrimitiveType getPrimitiveType(@NotNull DeclarationDescriptor descriptor2) {
        return KotlinBuiltIns.FQ_NAMES.primitiveTypeShortNames.contains(descriptor2.getName()) ? KotlinBuiltIns.FQ_NAMES.fqNameToPrimitiveType.get(DescriptorUtils.getFqName(descriptor2)) : null;
    }

    @Nullable
    public static PrimitiveType getPrimitiveArrayType(@NotNull DeclarationDescriptor descriptor2) {
        return KotlinBuiltIns.FQ_NAMES.primitiveArrayTypeShortNames.contains(descriptor2.getName()) ? KotlinBuiltIns.FQ_NAMES.arrayClassFqNameToPrimitiveType.get(DescriptorUtils.getFqName(descriptor2)) : null;
    }

    @NotNull
    public SimpleType getArrayType(@NotNull Variance projectionType, @NotNull KotlinType argument) {
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        return KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), this.getArray(), types);
    }

    public static boolean isArray(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.array);
    }

    public static boolean isArrayOrPrimitiveArray(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.classFqNameEquals(descriptor2, KotlinBuiltIns.FQ_NAMES.array) || KotlinBuiltIns.getPrimitiveArrayType(descriptor2) != null;
    }

    public static boolean isPrimitiveArray(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && KotlinBuiltIns.getPrimitiveArrayType(descriptor2) != null;
    }

    public static boolean isPrimitiveType(@NotNull KotlinType type2) {
        return !type2.isMarkedNullable() && KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(type2);
    }

    public static boolean isPrimitiveTypeOrNullablePrimitiveType(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2);
    }

    public static boolean isPrimitiveClass(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.getPrimitiveType(descriptor2) != null;
    }

    public static boolean isConstructedFromGivenClass(@NotNull KotlinType type2, @NotNull FqNameUnsafe fqName2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.classFqNameEquals(descriptor2, fqName2);
    }

    private static boolean classFqNameEquals(@NotNull ClassifierDescriptor descriptor2, @NotNull FqNameUnsafe fqName2) {
        return descriptor2.getName().equals(fqName2.shortName()) && fqName2.equals(DescriptorUtils.getFqName(descriptor2));
    }

    private static boolean isNotNullConstructedFromGivenClass(@NotNull KotlinType type2, @NotNull FqNameUnsafe fqName2) {
        return !type2.isMarkedNullable() && KotlinBuiltIns.isConstructedFromGivenClass(type2, fqName2);
    }

    public static boolean isSpecialClassWithNoSupertypes(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.classFqNameEquals(descriptor2, KotlinBuiltIns.FQ_NAMES.any) || KotlinBuiltIns.classFqNameEquals(descriptor2, KotlinBuiltIns.FQ_NAMES.nothing);
    }

    public static boolean isAny(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.classFqNameEquals(descriptor2, KotlinBuiltIns.FQ_NAMES.any);
    }

    public static boolean isBoolean(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._boolean);
    }

    public static boolean isChar(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._char);
    }

    public static boolean isInt(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._int);
    }

    public static boolean isByte(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._byte);
    }

    public static boolean isLong(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._long);
    }

    public static boolean isShort(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(type2, KotlinBuiltIns.FQ_NAMES._short);
    }

    public static boolean isFloat(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isFloatOrNullableFloat(type2) && !type2.isMarkedNullable();
    }

    public static boolean isFloatOrNullableFloat(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._float);
    }

    public static boolean isDouble(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isDoubleOrNullableDouble(type2) && !type2.isMarkedNullable();
    }

    public static boolean isDoubleOrNullableDouble(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES._double);
    }

    private static boolean isConstructedFromGivenClassAndNotNullable(@NotNull KotlinType type2, @NotNull FqNameUnsafe fqName2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, fqName2) && !type2.isMarkedNullable();
    }

    public static boolean isNothing(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isNothingOrNullableNothing(type2) && !type2.isMarkedNullable();
    }

    public static boolean isNothingOrNullableNothing(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.nothing);
    }

    public static boolean isAnyOrNullableAny(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.any);
    }

    public static boolean isNullableAny(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isAnyOrNullableAny(type2) && type2.isMarkedNullable();
    }

    public static boolean isDefaultBound(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isNullableAny(type2);
    }

    public static boolean isUnit(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.unit);
    }

    public static boolean isString(@Nullable KotlinType type2) {
        return type2 != null && KotlinBuiltIns.isNotNullConstructedFromGivenClass(type2, KotlinBuiltIns.FQ_NAMES.string);
    }

    public static boolean isKClass(@NotNull ClassDescriptor descriptor2) {
        return KotlinBuiltIns.classFqNameEquals(descriptor2, KotlinBuiltIns.FQ_NAMES.kClass);
    }

    public static boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (KotlinBuiltIns.containsAnnotation(declarationDescriptor, KotlinBuiltIns.FQ_NAMES.deprecated)) {
            return true;
        }
        if (declarationDescriptor instanceof PropertyDescriptor) {
            boolean isVar = ((PropertyDescriptor)declarationDescriptor).isVar();
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)declarationDescriptor).getGetter();
            PropertySetterDescriptor setter2 = ((PropertyDescriptor)declarationDescriptor).getSetter();
            return getter2 != null && KotlinBuiltIns.isDeprecated(getter2) && (!isVar || setter2 != null && KotlinBuiltIns.isDeprecated(setter2));
        }
        return false;
    }

    public static FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        return BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
    }

    private static boolean containsAnnotation(DeclarationDescriptor descriptor2, FqName annotationClassFqName) {
        DeclarationDescriptor original = descriptor2.getOriginal();
        Annotations annotations2 = original.getAnnotations();
        if (annotations2.findAnnotation(annotationClassFqName) != null) {
            return true;
        }
        AnnotationUseSiteTarget associatedUseSiteTarget = AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget(descriptor2);
        return associatedUseSiteTarget != null && Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, associatedUseSiteTarget, annotationClassFqName) != null;
    }

    public static class FqNames {
        public final FqNameUnsafe any = FqNames.fqNameUnsafe("Any");
        public final FqNameUnsafe nothing = FqNames.fqNameUnsafe("Nothing");
        public final FqNameUnsafe cloneable = FqNames.fqNameUnsafe("Cloneable");
        public final FqName suppress = FqNames.fqName("Suppress");
        public final FqNameUnsafe unit = FqNames.fqNameUnsafe("Unit");
        public final FqNameUnsafe charSequence = FqNames.fqNameUnsafe("CharSequence");
        public final FqNameUnsafe string = FqNames.fqNameUnsafe("String");
        public final FqNameUnsafe array = FqNames.fqNameUnsafe("Array");
        public final FqNameUnsafe _boolean = FqNames.fqNameUnsafe("Boolean");
        public final FqNameUnsafe _char = FqNames.fqNameUnsafe("Char");
        public final FqNameUnsafe _byte = FqNames.fqNameUnsafe("Byte");
        public final FqNameUnsafe _short = FqNames.fqNameUnsafe("Short");
        public final FqNameUnsafe _int = FqNames.fqNameUnsafe("Int");
        public final FqNameUnsafe _long = FqNames.fqNameUnsafe("Long");
        public final FqNameUnsafe _float = FqNames.fqNameUnsafe("Float");
        public final FqNameUnsafe _double = FqNames.fqNameUnsafe("Double");
        public final FqNameUnsafe number = FqNames.fqNameUnsafe("Number");
        public final FqNameUnsafe _enum = FqNames.fqNameUnsafe("Enum");
        public final FqNameUnsafe functionSupertype = FqNames.fqNameUnsafe("Function");
        public final FqName throwable = FqNames.fqName("Throwable");
        public final FqName comparable = FqNames.fqName("Comparable");
        public final FqNameUnsafe charRange = FqNames.rangesFqName("CharRange");
        public final FqNameUnsafe intRange = FqNames.rangesFqName("IntRange");
        public final FqNameUnsafe longRange = FqNames.rangesFqName("LongRange");
        public final FqName deprecated = FqNames.fqName("Deprecated");
        public final FqName deprecationLevel = FqNames.fqName("DeprecationLevel");
        public final FqName replaceWith = FqNames.fqName("ReplaceWith");
        public final FqName extensionFunctionType = FqNames.fqName("ExtensionFunctionType");
        public final FqName parameterName = FqNames.fqName("ParameterName");
        public final FqName annotation = FqNames.fqName("Annotation");
        public final FqName target = FqNames.annotationName("Target");
        public final FqName annotationTarget = FqNames.annotationName("AnnotationTarget");
        public final FqName annotationRetention = FqNames.annotationName("AnnotationRetention");
        public final FqName retention = FqNames.annotationName("Retention");
        public final FqName repeatable = FqNames.annotationName("Repeatable");
        public final FqName mustBeDocumented = FqNames.annotationName("MustBeDocumented");
        public final FqName unsafeVariance = FqNames.fqName("UnsafeVariance");
        public final FqName publishedApi = FqNames.fqName("PublishedApi");
        public final FqName iterator = FqNames.collectionsFqName("Iterator");
        public final FqName iterable = FqNames.collectionsFqName("Iterable");
        public final FqName collection = FqNames.collectionsFqName("Collection");
        public final FqName list = FqNames.collectionsFqName("List");
        public final FqName listIterator = FqNames.collectionsFqName("ListIterator");
        public final FqName set = FqNames.collectionsFqName("Set");
        public final FqName map = FqNames.collectionsFqName("Map");
        public final FqName mapEntry = this.map.child(Name.identifier("Entry"));
        public final FqName mutableIterator = FqNames.collectionsFqName("MutableIterator");
        public final FqName mutableIterable = FqNames.collectionsFqName("MutableIterable");
        public final FqName mutableCollection = FqNames.collectionsFqName("MutableCollection");
        public final FqName mutableList = FqNames.collectionsFqName("MutableList");
        public final FqName mutableListIterator = FqNames.collectionsFqName("MutableListIterator");
        public final FqName mutableSet = FqNames.collectionsFqName("MutableSet");
        public final FqName mutableMap = FqNames.collectionsFqName("MutableMap");
        public final FqName mutableMapEntry = this.mutableMap.child(Name.identifier("MutableEntry"));
        public final FqNameUnsafe kClass = FqNames.reflect("KClass");
        public final FqNameUnsafe kCallable = FqNames.reflect("KCallable");
        public final FqNameUnsafe kProperty0 = FqNames.reflect("KProperty0");
        public final FqNameUnsafe kProperty1 = FqNames.reflect("KProperty1");
        public final FqNameUnsafe kProperty2 = FqNames.reflect("KProperty2");
        public final FqNameUnsafe kMutableProperty0 = FqNames.reflect("KMutableProperty0");
        public final FqNameUnsafe kMutableProperty1 = FqNames.reflect("KMutableProperty1");
        public final FqNameUnsafe kMutableProperty2 = FqNames.reflect("KMutableProperty2");
        public final ClassId kProperty = ClassId.topLevel(FqNames.reflect("KProperty").toSafe());
        public final Set<Name> primitiveTypeShortNames = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
        public final Set<Name> primitiveArrayTypeShortNames = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
        public final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
        public final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);

        public FqNames() {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                this.primitiveTypeShortNames.add(primitiveType.getTypeName());
                this.primitiveArrayTypeShortNames.add(primitiveType.getArrayTypeName());
                this.fqNameToPrimitiveType.put(FqNames.fqNameUnsafe(primitiveType.getTypeName().asString()), primitiveType);
                this.arrayClassFqNameToPrimitiveType.put(FqNames.fqNameUnsafe(primitiveType.getArrayTypeName().asString()), primitiveType);
            }
        }

        @NotNull
        private static FqNameUnsafe fqNameUnsafe(@NotNull String simpleName2) {
            return FqNames.fqName(simpleName2).toUnsafe();
        }

        @NotNull
        private static FqName fqName(@NotNull String simpleName2) {
            return BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
        }

        @NotNull
        private static FqName collectionsFqName(@NotNull String simpleName2) {
            return COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
        }

        @NotNull
        private static FqNameUnsafe rangesFqName(@NotNull String simpleName2) {
            return RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
        }

        @NotNull
        private static FqNameUnsafe reflect(@NotNull String simpleName2) {
            return ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().child(Name.identifier(simpleName2)).toUnsafe();
        }

        @NotNull
        private static FqName annotationName(@NotNull String simpleName2) {
            return ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
        }
    }

    private static class PackageFragments {
        public final PackageFragmentDescriptor builtInsPackageFragment;
        public final PackageFragmentDescriptor collectionsPackageFragment;
        public final PackageFragmentDescriptor annotationPackageFragment;
        public final Set<PackageFragmentDescriptor> allImportedByDefaultBuiltInsPackageFragments;

        private PackageFragments(@NotNull PackageFragmentDescriptor builtInsPackageFragment, @NotNull PackageFragmentDescriptor collectionsPackageFragment, @NotNull PackageFragmentDescriptor annotationPackageFragment, @NotNull Set<PackageFragmentDescriptor> allImportedByDefaultBuiltInsPackageFragments) {
            this.builtInsPackageFragment = builtInsPackageFragment;
            this.collectionsPackageFragment = collectionsPackageFragment;
            this.annotationPackageFragment = annotationPackageFragment;
            this.allImportedByDefaultBuiltInsPackageFragments = allImportedByDefaultBuiltInsPackageFragments;
        }
    }

    private static class Primitives {
        public final Map<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType;
        public final Map<KotlinType, SimpleType> primitiveKotlinTypeToKotlinArrayType;
        public final Map<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType;

        private Primitives(@NotNull Map<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType, @NotNull Map<KotlinType, SimpleType> primitiveKotlinTypeToKotlinArrayType, @NotNull Map<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType) {
            this.primitiveTypeToArrayKotlinType = primitiveTypeToArrayKotlinType;
            this.primitiveKotlinTypeToKotlinArrayType = primitiveKotlinTypeToKotlinArrayType;
            this.kotlinArrayTypeToPrimitiveKotlinType = kotlinArrayTypeToPrimitiveKotlinType;
        }
    }
}

