/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.BitEncoding;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmProtoBufUtil {
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;
    public static final JvmProtoBufUtil INSTANCE;

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        NameResolver nameResolver = INSTANCE.readNameResolver(input, strings);
        ProtoBuf.Class clazz = ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(clazz, "ProtoBuf.Class.parseFrom\u2026nput, EXTENSION_REGISTRY)");
        return new ClassData(nameResolver, clazz);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        NameResolver nameResolver = INSTANCE.readNameResolver(input, strings);
        ProtoBuf.Package package_ = ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(package_, "ProtoBuf.Package.parseFr\u2026nput, EXTENSION_REGISTRY)");
        return new PackageData(nameResolver, package_);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(BitEncoding.decodeBytes(data2));
        return new Pair<JvmNameResolver, ProtoBuf.Function>(INSTANCE.readNameResolver(input, strings), ProtoBuf.Function.parseFrom(input, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(@NotNull InputStream $receiver, String[] strings) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom($receiver, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(stringTableTypes, "JvmProtoBuf.StringTableT\u2026this, EXTENSION_REGISTRY)");
        return new JvmNameResolver(stringTableTypes, strings);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, "JvmProtoBuf.methodSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n = name = signature2 != null && signature2.hasName() ? signature2.getName() : proto.getName();
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Object object;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Collection collection = CollectionsKt.listOfNotNull(ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            List<ProtoBuf.ValueParameter> list2 = proto.getValueParameterList();
            Intrinsics.checkExpressionValueIsNotNull(list2, "proto.valueParameterList");
            Iterable iterable = list2;
            Collection collection2 = collection;
            void var9_8 = $receiver$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                object = destination$iv$iv;
                void v6 = it;
                Intrinsics.checkExpressionValueIsNotNull(v6, "it");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)v6, typeTable);
                object.add(type2);
            }
            object = (List)destination$iv$iv;
            List parameterTypes = CollectionsKt.plus(collection2, (Iterable)object);
            Iterable $receiver$iv2 = parameterTypes;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Type $i$a$1$map = (ProtoBuf.Type)item$iv$iv;
                collection2 = destination$iv$iv2;
                if (INSTANCE.mapTypeDefault((ProtoBuf.Type)it, nameResolver) == null) {
                    return null;
                }
                collection2.add(object);
            }
            List parametersDesc = (List)destination$iv$iv2;
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            String returnTypeDesc = string2;
            string = CollectionsKt.joinToString$default(parametersDesc, "", "(", ")", 0, null, null, 56, null) + returnTypeDesc;
        }
        String desc = string;
        return nameResolver.getString(name) + desc;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, "JvmProtoBuf.constructorSignature");
        JvmProtoBuf.JvmMethodSignature signature2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<ProtoBuf.ValueParameter> list2 = proto.getValueParameterList();
            Intrinsics.checkExpressionValueIsNotNull(list2, "proto.valueParameterList");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string2;
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                if (INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)v4, typeTable), nameResolver) == null) {
                    return null;
                }
                collection.add(string2);
            }
            string = CollectionsKt.joinToString$default((List)destination$iv$iv, "", "(", ")V", 0, null, null, 56, null);
        }
        String desc = string;
        return "<init>" + desc;
    }

    @Nullable
    public final PropertySignature getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkExpressionValueIsNotNull(generatedExtension, "JvmProtoBuf.propertySignature");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature2 = jvmPropertySignature;
        JvmProtoBuf.JvmFieldSignature field = signature2.hasField() ? signature2.getField() : null;
        int n = name = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        String string2 = nameResolver.getString(name);
        Intrinsics.checkExpressionValueIsNotNull(string2, "nameResolver.getString(name)");
        String string3 = desc;
        Intrinsics.checkExpressionValueIsNotNull(string3, "desc");
        return new PropertySignature(string2, string3);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        String string;
        if (type2.hasClassName()) {
            ClassId classId = nameResolver.getClassId(type2.getClassName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(type.className)");
            string = ClassMapperLite.mapClass(classId);
        } else {
            string = null;
        }
        return string;
    }

    private JvmProtoBufUtil() {
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        JvmProtoBufUtil jvmProtoBufUtil;
        INSTANCE = jvmProtoBufUtil = new JvmProtoBufUtil();
        ExtensionRegistryLite p1 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(p1);
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite;
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite2, "ExtensionRegistryLite.ne\u2026f::registerAllExtensions)");
        EXTENSION_REGISTRY = extensionRegistryLite2;
    }

    public static final class PropertySignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public PropertySignature(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            this.name = name;
            this.desc = desc;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.desc;
        }

        public String toString() {
            return "PropertySignature(name=" + this.name + ", desc=" + this.desc + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.desc;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertySignature)) break block3;
                    PropertySignature propertySignature = (PropertySignature)object;
                    if (!Intrinsics.areEqual(this.name, propertySignature.name) || !Intrinsics.areEqual(this.desc, propertySignature.desc)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

