/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.FilteredAnnotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeVariable;
import kotlin.reflect.jvm.internal.impl.types.DisjointKeysUnionTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.utils.ExceptionUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    @NotNull
    private final TypeSubstitution substitution;

    @NotNull
    public static TypeSubstitutor create(@NotNull TypeSubstitution substitution2) {
        return new TypeSubstitutor(substitution2);
    }

    @NotNull
    public static TypeSubstitutor createChainedSubstitutor(@NotNull TypeSubstitution first2, @NotNull TypeSubstitution second) {
        return TypeSubstitutor.create(DisjointKeysUnionTypeSubstitution.create(first2, second));
    }

    @NotNull
    public static TypeSubstitutor create(@NotNull KotlinType context) {
        return TypeSubstitutor.create(TypeConstructorSubstitution.create(context.getConstructor(), context.getArguments()));
    }

    protected TypeSubstitutor(@NotNull TypeSubstitution substitution2) {
        this.substitution = substitution2;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @NotNull
    public TypeSubstitution getSubstitution() {
        return this.substitution;
    }

    @NotNull
    public KotlinType safeSubstitute(@NotNull KotlinType type2, @NotNull Variance howThisTypeIsUsed) {
        if (this.isEmpty()) {
            return type2;
        }
        try {
            return this.unsafeSubstitute(new TypeProjectionImpl(howThisTypeIsUsed, type2), 0).getType();
        }
        catch (SubstitutionException e) {
            return ErrorUtils.createErrorType(e.getMessage());
        }
    }

    @Nullable
    public KotlinType substitute(@NotNull KotlinType type2, @NotNull Variance howThisTypeIsUsed) {
        TypeProjection projection = this.substitute(new TypeProjectionImpl(howThisTypeIsUsed, this.getSubstitution().prepareTopLevelType(type2, howThisTypeIsUsed)));
        return projection == null ? null : projection.getType();
    }

    @Nullable
    public TypeProjection substitute(@NotNull TypeProjection typeProjection) {
        TypeProjection substitutedTypeProjection = this.substituteWithoutApproximation(typeProjection);
        if (!this.substitution.approximateCapturedTypes() && !this.substitution.approximateContravariantCapturedTypes()) {
            return substitutedTypeProjection;
        }
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary(substitutedTypeProjection, this.substitution.approximateContravariantCapturedTypes());
    }

    @Nullable
    public TypeProjection substituteWithoutApproximation(@NotNull TypeProjection typeProjection) {
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, 0);
        }
        catch (SubstitutionException e) {
            return null;
        }
    }

    @NotNull
    private TypeProjection unsafeSubstitute(@NotNull TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        TypeSubstitutor.assertRecursionDepth(recursionDepth, originalProjection, this.substitution);
        if (originalProjection.isStarProjection()) {
            return originalProjection;
        }
        KotlinType type2 = originalProjection.getType();
        if (type2 instanceof TypeWithEnhancement) {
            UnwrappedType origin = ((TypeWithEnhancement)((Object)type2)).getOrigin();
            KotlinType enhancement2 = ((TypeWithEnhancement)((Object)type2)).getEnhancement();
            TypeProjection substitution2 = this.unsafeSubstitute(new TypeProjectionImpl(originalProjection.getProjectionKind(), origin), recursionDepth + 1);
            KotlinType substitutedEnhancement = this.substitute(enhancement2, originalProjection.getProjectionKind());
            UnwrappedType resultingType = TypeWithEnhancementKt.wrapEnhancement(substitution2.getType().unwrap(), substitutedEnhancement);
            return new TypeProjectionImpl(substitution2.getProjectionKind(), resultingType);
        }
        if (DynamicTypesKt.isDynamic(type2) || type2.unwrap() instanceof RawType) {
            return originalProjection;
        }
        TypeProjection replacement = this.substitution.get(type2);
        Variance originalProjectionKind = originalProjection.getProjectionKind();
        if (replacement == null && FlexibleTypesKt.isFlexible(type2) && !TypeCapabilitiesKt.isCustomTypeVariable(type2)) {
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            TypeProjection substitutedLower = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibleType.getLowerBound()), recursionDepth + 1);
            TypeProjection substitutedUpper = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibleType.getUpperBound()), recursionDepth + 1);
            Variance substitutedProjectionKind = substitutedLower.getProjectionKind();
            assert (substitutedProjectionKind == substitutedUpper.getProjectionKind() && originalProjectionKind == Variance.INVARIANT || originalProjectionKind == substitutedProjectionKind) : "Unexpected substituted projection kind: " + (Object)((Object)substitutedProjectionKind) + "; original: " + (Object)((Object)originalProjectionKind);
            if (substitutedLower.getType() == flexibleType.getLowerBound() && substitutedUpper.getType() == flexibleType.getUpperBound()) {
                return originalProjection;
            }
            UnwrappedType substitutedFlexibleType = KotlinTypeFactory.flexibleType(TypeSubstitutionKt.asSimpleType(substitutedLower.getType()), TypeSubstitutionKt.asSimpleType(substitutedUpper.getType()));
            return new TypeProjectionImpl(substitutedProjectionKind, substitutedFlexibleType);
        }
        if (KotlinBuiltIns.isNothing(type2) || KotlinTypeKt.isError(type2)) {
            return originalProjection;
        }
        if (replacement != null) {
            VarianceConflictType varianceConflict = TypeSubstitutor.conflictType(originalProjectionKind, replacement.getProjectionKind());
            boolean allowVarianceConflict = CapturedTypeConstructorKt.isCaptured(type2);
            if (!allowVarianceConflict) {
                switch (varianceConflict) {
                    case OUT_IN_IN_POSITION: {
                        throw new SubstitutionException("Out-projection in in-position");
                    }
                    case IN_IN_OUT_POSITION: {
                        return new TypeProjectionImpl(Variance.OUT_VARIANCE, type2.getConstructor().getBuiltIns().getNullableAnyType());
                    }
                }
            }
            CustomTypeVariable typeVariable2 = TypeCapabilitiesKt.getCustomTypeVariable(type2);
            if (replacement.isStarProjection()) {
                return replacement;
            }
            KotlinType substitutedType = typeVariable2 != null ? typeVariable2.substitutionResult(replacement.getType()) : TypeUtils.makeNullableIfNeeded(replacement.getType(), type2.isMarkedNullable());
            if (!type2.getAnnotations().isEmpty()) {
                Annotations typeAnnotations = TypeSubstitutor.filterOutUnsafeVariance(this.substitution.filterAnnotations(type2.getAnnotations()));
                substitutedType = TypeUtilsKt.replaceAnnotations(substitutedType, new CompositeAnnotations(substitutedType.getAnnotations(), typeAnnotations));
            }
            Variance resultingProjectionKind = varianceConflict == VarianceConflictType.NO_CONFLICT ? TypeSubstitutor.combine(originalProjectionKind, replacement.getProjectionKind()) : originalProjectionKind;
            return new TypeProjectionImpl(resultingProjectionKind, substitutedType);
        }
        return this.substituteCompoundType(originalProjection, recursionDepth);
    }

    @NotNull
    private static Annotations filterOutUnsafeVariance(@NotNull Annotations annotations2) {
        if (!annotations2.hasAnnotation(KotlinBuiltIns.FQ_NAMES.unsafeVariance)) {
            return annotations2;
        }
        return new FilteredAnnotations(annotations2, (Function1<? super FqName, Boolean>)new Function1<FqName, Boolean>(){

            @Override
            public Boolean invoke(@NotNull FqName name) {
                return !name.equals(KotlinBuiltIns.FQ_NAMES.unsafeVariance);
            }
        });
    }

    private TypeProjection substituteCompoundType(TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        List<TypeProjection> substitutedArguments;
        KotlinType substitutedType;
        KotlinType type2 = originalProjection.getType();
        Variance projectionKind = originalProjection.getProjectionKind();
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return originalProjection;
        }
        KotlinType substitutedAbbreviation = null;
        SimpleType abbreviation = SpecialTypesKt.getAbbreviation(type2);
        if (abbreviation != null) {
            substitutedAbbreviation = this.substitute(abbreviation, Variance.INVARIANT);
        }
        if ((substitutedType = TypeSubstitutionKt.replace(type2, substitutedArguments = this.substituteTypeArguments(type2.getConstructor().getParameters(), type2.getArguments(), recursionDepth), this.substitution.filterAnnotations(type2.getAnnotations()))) instanceof SimpleType && substitutedAbbreviation instanceof SimpleType) {
            substitutedType = SpecialTypesKt.withAbbreviation((SimpleType)substitutedType, (SimpleType)substitutedAbbreviation);
        }
        return new TypeProjectionImpl(projectionKind, substitutedType);
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> typeParameters2, List<TypeProjection> typeArguments2, int recursionDepth) throws SubstitutionException {
        ArrayList<TypeProjection> substitutedArguments = new ArrayList<TypeProjection>(typeParameters2.size());
        boolean wereChanges = false;
        for (int i = 0; i < typeParameters2.size(); ++i) {
            TypeParameterDescriptor typeParameter = typeParameters2.get(i);
            TypeProjection typeArgument = typeArguments2.get(i);
            TypeProjection substitutedTypeArgument = this.unsafeSubstitute(typeArgument, recursionDepth + 1);
            switch (TypeSubstitutor.conflictType(typeParameter.getVariance(), substitutedTypeArgument.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameter.getVariance() == Variance.INVARIANT || substitutedTypeArgument.isStarProjection()) break;
                    substitutedTypeArgument = new TypeProjectionImpl(Variance.INVARIANT, substitutedTypeArgument.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    substitutedTypeArgument = TypeUtils.makeStarProjection(typeParameter);
                }
            }
            if (substitutedTypeArgument != typeArgument) {
                wereChanges = true;
            }
            substitutedArguments.add(substitutedTypeArgument);
        }
        if (!wereChanges) {
            return typeArguments2;
        }
        return substitutedArguments;
    }

    @NotNull
    public static Variance combine(@NotNull Variance typeParameterVariance, @NotNull TypeProjection typeProjection) {
        if (typeProjection.isStarProjection()) {
            return Variance.OUT_VARIANCE;
        }
        return TypeSubstitutor.combine(typeParameterVariance, typeProjection.getProjectionKind());
    }

    @NotNull
    public static Variance combine(@NotNull Variance typeParameterVariance, @NotNull Variance projectionKind) {
        if (typeParameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return typeParameterVariance;
        }
        if (typeParameterVariance == projectionKind) {
            return projectionKind;
        }
        throw new AssertionError((Object)("Variance conflict: type parameter variance '" + (Object)((Object)typeParameterVariance) + "' and " + "projection kind '" + (Object)((Object)projectionKind) + "' cannot be combined"));
    }

    private static VarianceConflictType conflictType(Variance position, Variance argument) {
        if (position == Variance.IN_VARIANCE && argument == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (position == Variance.OUT_VARIANCE && argument == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int recursionDepth, TypeProjection projection, TypeSubstitution substitution2) {
        if (recursionDepth > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(projection) + "; substitution: " + TypeSubstitutor.safeToString(substitution2));
        }
    }

    private static String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (Throwable e) {
            if (ExceptionUtilsKt.isProcessCanceledException(e)) {
                throw (RuntimeException)e;
            }
            return "[Exception while computing toString(): " + e + "]";
        }
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String message) {
            super(message);
        }
    }
}

