/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\b\u0018\u00010\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007J \u0010\u000b\u001a\b\u0018\u00010\u0006R\u00020\u00072\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004J\u001a\u0010\r\u001a\u00020\u000e2\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/MarkdownParserUtil;", "", "()V", "calcNumberOfConsequentEols", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "findNonEmptyLineWithSameConstraints", "getFirstNonWhitespaceLinePos", "eolsToSkip", "hasCodeBlockIndent", "", "isEmptyOrSpaces", "s", "", "intellij-markdown"})
public final class MarkdownParserUtil {
    public static final MarkdownParserUtil INSTANCE;

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        boolean bl = pos.getChar() == '\n';
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        LookaheadText.Position currentPos = pos;
        int result2 = 1;
        Function1 isClearLine2 = new Function1<LookaheadText.Position, Boolean>(constraints){
            final /* synthetic */ MarkdownConstraints $constraints;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull LookaheadText.Position pos) {
                Intrinsics.checkParameterIsNotNull(pos, "pos");
                MarkdownConstraints currentConstraints = MarkdownConstraints.Companion.fillFromPrevious(pos.getCurrentLine(), 0, this.$constraints);
                int constraintsLength = currentConstraints.getCharsEaten(pos.getCurrentLine());
                if (!currentConstraints.upstreamWith(this.$constraints)) return false;
                if (constraintsLength >= pos.getCurrentLine().length()) return true;
                LookaheadText.Position position = pos.nextPosition(1 + constraintsLength);
                if (position == null) return true;
                Integer n = position.charsToNonWhitespace();
                if (n != null) return false;
                return true;
            }
            {
                this.$constraints = markdownConstraints;
                super(1);
            }
        };
        while (((Boolean)isClearLine2.invoke(currentPos)).booleanValue()) {
            if (currentPos.nextLinePosition() == null) {
                break;
            }
            if (++result2 <= 4) continue;
            break;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        void currentPos;
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = pos;
        int n = eolsToSkip - 1;
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            do {
                int it = ++n2;
                if (pos.nextLinePosition() == null) {
                    Object cfr_ignored_0 = currentPos.element;
                    return null;
                }
                currentPos.element = currentPos.element;
            } while (n2 != n3);
        }
        while (((LookaheadText.Position)currentPos.element).charsToNonWhitespace() == null) {
            if (((LookaheadText.Position)currentPos.element).nextLinePosition() == null) {
                Object cfr_ignored_1 = currentPos.element;
                return null;
            }
            currentPos.element = currentPos.element;
        }
        return (LookaheadText.Position)currentPos.element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        int constraintsLength = constraints.getCharsEaten(pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int n = constraintsLength;
        int n2 = pos.getOffsetInCurrentLine();
        if (n <= n2) {
            while (true) {
                void i;
                if (pos.getCurrentLine().charAt((int)i) == '\t') {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        CharIterator charIterator = StringsKt.iterator(s);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while ((nextLineConstraints = MarkdownConstraints.Companion.fromBase(currentPos, constraints)).upstreamWith(constraints) && nextLineConstraints.extendsPrev(constraints)) {
            CharSequence stringAfterConstraints = nextLineConstraints.eatItselfFromString(currentPos.getCurrentLine());
            if (!INSTANCE.isEmptyOrSpaces(stringAfterConstraints)) {
                return currentPos;
            }
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return null;
    }

    private MarkdownParserUtil() {
        INSTANCE = this;
    }

    static {
        new MarkdownParserUtil();
    }
}

