/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\n\u0010\u0011\u001a\u00060\u0012R\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\rH\u0016J\u0014\u0010\u001c\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/AtxHeaderMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "headerRange", "Lkotlin/ranges/IntRange;", "tailStartPos", "", "endOfLinePos", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lkotlin/ranges/IntRange;II)V", "nodeType", "Lorg/intellij/markdown/IElementType;", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "calcNodeType", "headerSize", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "isInterestingOffset", "intellij-markdown"})
public final class AtxHeaderMarkerBlock
extends MarkerBlockImpl {
    private final IElementType nodeType;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return true;
    }

    private final IElementType calcNodeType(int headerSize) {
        switch (headerSize) {
            case 1: {
                return MarkdownElementTypes.ATX_1;
            }
            case 2: {
                return MarkdownElementTypes.ATX_2;
            }
            case 3: {
                return MarkdownElementTypes.ATX_3;
            }
            case 4: {
                return MarkdownElementTypes.ATX_4;
            }
            case 5: {
                return MarkdownElementTypes.ATX_5;
            }
            case 6: {
                return MarkdownElementTypes.ATX_6;
            }
        }
        return MarkdownElementTypes.ATX_6;
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(currentConstraints, "currentConstraints");
        if (pos.getOffsetInCurrentLine() == -1) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DONE, MarkerBlock.EventAction.PROPAGATE);
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    public AtxHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull IntRange headerRange, int tailStartPos, int endOfLinePos) {
        Intrinsics.checkParameterIsNotNull(myConstraints, "myConstraints");
        Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
        Intrinsics.checkParameterIsNotNull(headerRange, "headerRange");
        super(myConstraints, productionHolder.mark());
        int curPos = productionHolder.getCurrentPosition();
        productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node[]{new SequentialParser.Node(new IntRange(curPos + ((Number)headerRange.getStart()).intValue(), curPos + ((Number)headerRange.getEndInclusive()).intValue() + 1), MarkdownTokenTypes.ATX_HEADER), new SequentialParser.Node(new IntRange(curPos + ((Number)headerRange.getEndInclusive()).intValue() + 1, tailStartPos), MarkdownTokenTypes.ATX_CONTENT), new SequentialParser.Node(new IntRange(tailStartPos, endOfLinePos), MarkdownTokenTypes.ATX_HEADER)}));
        this.nodeType = this.calcNodeType(((Number)headerRange.getEndInclusive()).intValue() - ((Number)headerRange.getStart()).intValue() + 1);
    }
}

