/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion", "intellij-markdown"})
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    private static final String WHSP = "[ \\t]*";
    @NotNull
    private static final Function1<String, String> NOT_CHARS;
    @NotNull
    private static final String NONCONTROL = "(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])";
    @NotNull
    private static final String LINK_DESTINATION = "(?:<(?:\\\\[<>]|[^<>\\n])*>|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\((?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*\\)(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])*|(?:\\\\[\\(\\)]|[^ \\n\\t\\(\\)])+)";
    @NotNull
    private static final String LINK_TITLE;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
        Intrinsics.checkParameterIsNotNull(stateInfo, "stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list2 = Companion.matchLinkDefinition(pos.getTextFromPosition());
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list2;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)matchResult)) {
            IElementType iElementType;
            int i = indexedValue.component1();
            IntRange range = (IntRange)indexedValue.component2();
            IntRange intRange = Companion.addToRangeAndWiden(range, pos.getOffset());
            switch (i) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    iElementType = MarkdownElementTypes.LINK_TITLE;
                    break;
                }
                default: {
                    throw (Throwable)((Object)new AssertionError((Object)"There are no more than three groups in this regex"));
                }
            }
            productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(intRange, iElementType)));
        }
        int matchLength = ((Number)CollectionsKt.last(matchResult).getEndInclusive()).intValue() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf(new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        return false;
    }

    static {
        Companion = new Companion(null);
        WHSP = WHSP;
        NOT_CHARS = Companion.NOT_CHARS.1.INSTANCE;
        NONCONTROL = NONCONTROL;
        LINK_DESTINATION = "(?:<(?:" + "\\" + "\\" + "[<>]|[^<>" + "\\" + "n])*>|" + Companion.getNONCONTROL() + "*" + "\\" + "(" + Companion.getNONCONTROL() + "*" + "\\" + ")" + Companion.getNONCONTROL() + "*|" + Companion.getNONCONTROL() + "+)";
        LINK_TITLE = "(?:" + "\"" + Companion.getNOT_CHARS().invoke("\"") + "\"" + "|'" + Companion.getNOT_CHARS().invoke("'") + "'|" + "\\" + "(" + Companion.getNOT_CHARS().invoke("\\)") + "\\" + "))";
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001aJ\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0015J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "()V", "LINK_DESTINATION", "", "getLINK_DESTINATION", "()Ljava/lang/String;", "LINK_TITLE", "getLINK_TITLE", "NONCONTROL", "getNONCONTROL", "NOT_CHARS", "Lkotlin/Function1;", "getNOT_CHARS", "()Lkotlin/jvm/functions/Function1;", "WHSP", "getWHSP", "addToRangeAndWiden", "Lkotlin/ranges/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "matchLinkDefinition", "", "text", "", "matchLinkLabel", "start", "passOneNewline", "intellij-markdown"})
    public static final class Companion {
        @NotNull
        public final String getWHSP() {
            return WHSP;
        }

        @NotNull
        public final Function1<String, String> getNOT_CHARS() {
            return NOT_CHARS;
        }

        @NotNull
        public final String getNONCONTROL() {
            return NONCONTROL;
        }

        @NotNull
        public final String getLINK_DESTINATION() {
            return LINK_DESTINATION;
        }

        @NotNull
        public final String getLINK_TITLE() {
            return LINK_TITLE;
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkParameterIsNotNull(range, "range");
            return new IntRange(((Number)range.getStart()).intValue() + t, ((Number)range.getEndInclusive()).intValue() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkParameterIsNotNull(pos, "pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text2) {
            void offset2;
            Intrinsics.checkParameterIsNotNull(text2, "text");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            int n = 3;
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                do {
                    int it = ++n2;
                    if (offset2.element < text2.length() && text2.charAt(offset2.element) == ' ') {
                        int n4 = offset2.element;
                        offset2.element = n4 + 1;
                    }
                } while (n2 != n3);
            }
            IntRange intRange = this.matchLinkLabel(text2, offset2.element);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset2.element = ((Number)linkLabel.getEndInclusive()).intValue() + 1;
            if (offset2.element >= text2.length() || text2.charAt(offset2.element) != ':') {
                return null;
            }
            n2 = offset2.element;
            offset2.element = n2 + 1;
            offset2.element = this.passOneNewline(text2, offset2.element);
            MatchResult matchResult = Regex.find$default(new Regex("^" + this.getLINK_DESTINATION()), text2.subSequence(offset2.element, text2.length()), 0, 2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult destination = matchResult;
            IntRange destinationRange = new IntRange(((Number)destination.getRange().getStart()).intValue() + offset2.element, ((Number)destination.getRange().getEndInclusive()).intValue() + offset2.element);
            offset2.element += ((Number)destination.getRange().getEndInclusive()).intValue() - ((Number)destination.getRange().getStart()).intValue() + 1;
            offset2.element = this.passOneNewline(text2, offset2.element);
            MatchResult title = Regex.find$default(new Regex("^" + this.getLINK_TITLE()), text2.subSequence(offset2.element, text2.length()), 0, 2, null);
            ArrayList<IntRange> result2 = new ArrayList<IntRange>();
            result2.add(linkLabel);
            result2.add(destinationRange);
            if (title != null) {
                IntRange titleRange = new IntRange(((Number)title.getRange().getStart()).intValue() + offset2.element, ((Number)title.getRange().getEndInclusive()).intValue() + offset2.element);
                offset2.element += ((Number)title.getRange().getEndInclusive()).intValue() - ((Number)title.getRange().getStart()).intValue() + 1;
                while (offset2.element < text2.length()) {
                    int n5 = text2.charAt(offset2.element);
                    int it = n5;
                    if (!(it == 32 || it == 9)) break;
                    n5 = offset2.element;
                    offset2.element = n5 + 1;
                }
                if (offset2.element >= text2.length() || text2.charAt(offset2.element) == '\n') {
                    result2.add(titleRange);
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text2, int start) {
            Intrinsics.checkParameterIsNotNull(text2, "text");
            int offset2 = start;
            if (offset2 >= text2.length() || text2.charAt(offset2) != '[') {
                return null;
            }
            ++offset2;
            boolean seenNonWhitespace = false;
            int n = 1;
            int n2 = 999;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (offset2 >= text2.length()) {
                        return null;
                    }
                    char c = text2.charAt(offset2);
                    if (c == '[' || c == ']') break;
                    if (c == '\\') {
                        if (++offset2 >= text2.length()) {
                            return null;
                        }
                        c = text2.charAt(offset2);
                    }
                    if (!CharsKt.isWhitespace(c)) {
                        seenNonWhitespace = true;
                    }
                    ++offset2;
                    if (i == n2) break;
                    ++i;
                }
            }
            if (!seenNonWhitespace || offset2 >= text2.length() || text2.charAt(offset2) != ']') {
                return null;
            }
            return new IntRange(start, offset2);
        }

        private final int passOneNewline(CharSequence text2, int start) {
            char it;
            char c;
            int offset2;
            for (offset2 = start; offset2 < text2.length(); ++offset2) {
                c = text2.charAt(offset2);
                it = c;
                if (!(it == ' ' || it == '\t')) break;
            }
            if (offset2 < text2.length() && text2.charAt(offset2) == '\n') {
                ++offset2;
                while (offset2 < text2.length()) {
                    c = text2.charAt(offset2);
                    it = c;
                    if (!(it == ' ' || it == '\t')) break;
                    ++offset2;
                }
            }
            return offset2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

