/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.LanguageService;
import org.jetbrains.dokka.LocationService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\bR\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/dokka/ConsoleGenerator;", "", "signatureGenerator", "Lorg/jetbrains/dokka/LanguageService;", "locationService", "Lorg/jetbrains/dokka/LocationService;", "(Lorg/jetbrains/dokka/LanguageService;Lorg/jetbrains/dokka/LocationService;)V", "IndentStep", "", "getIndentStep", "()Ljava/lang/String;", "getLocationService", "()Lorg/jetbrains/dokka/LocationService;", "getSignatureGenerator", "()Lorg/jetbrains/dokka/LanguageService;", "generate", "", "node", "Lorg/jetbrains/dokka/DocumentationNode;", "indent", "generateDetails", "generateHeader", "generateLinks", "generateMembers", "core"})
public final class ConsoleGenerator {
    @NotNull
    private final String IndentStep = "  ";
    @NotNull
    private final LanguageService signatureGenerator;
    @NotNull
    private final LocationService locationService;

    @NotNull
    public final String getIndentStep() {
        return this.IndentStep;
    }

    public final void generate(@NotNull DocumentationNode node, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(indent, "indent");
        String string = '@' + this.locationService.location(node).getPath();
        System.out.println((Object)string);
        this.generateHeader(node, indent);
        this.generateMembers(node, indent);
        this.generateLinks(node, indent);
    }

    public static /* synthetic */ void generate$default(ConsoleGenerator consoleGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        consoleGenerator.generate(documentationNode, string);
    }

    public final void generateHeader(@NotNull DocumentationNode node, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(indent, "indent");
        String string = indent + LanguageService.DefaultImpls.render$default(this.signatureGenerator, node, null, 2, null);
        System.out.println((Object)string);
        String docString = node.getContent().toString();
        CharSequence charSequence = docString;
        if (!(charSequence.length() == 0)) {
            charSequence = indent + '\"' + StringsKt.replace$default(docString, "\n", '\n' + indent, false, 4, null) + '\"';
            System.out.println(charSequence);
        }
        System.out.println();
    }

    public static /* synthetic */ void generateHeader$default(ConsoleGenerator consoleGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        consoleGenerator.generateHeader(documentationNode, string);
    }

    public final void generateMembers(@NotNull DocumentationNode node, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(indent, "indent");
        Iterable $receiver$iv = node.getMembers();
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                DocumentationNode it = (DocumentationNode)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (DocumentationNode)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = it.getName();
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
            }
        };
        List<DocumentationNode> items = CollectionsKt.sortedWith(iterable, comparator);
        for (DocumentationNode child : items) {
            this.generate(child, indent + this.IndentStep);
        }
    }

    public static /* synthetic */ void generateMembers$default(ConsoleGenerator consoleGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        consoleGenerator.generateMembers(documentationNode, string);
    }

    public final void generateDetails(@NotNull DocumentationNode node, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(indent, "indent");
        List<DocumentationNode> items = node.getDetails();
        for (DocumentationNode child : items) {
            this.generate(child, indent + "  ");
        }
    }

    public static /* synthetic */ void generateDetails$default(ConsoleGenerator consoleGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        consoleGenerator.generateDetails(documentationNode, string);
    }

    public final void generateLinks(@NotNull DocumentationNode node, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(indent, "indent");
        List<DocumentationNode> items = node.getLinks();
        if (items.isEmpty()) {
            return;
        }
        String string = indent + " Links";
        System.out.println((Object)string);
        for (DocumentationNode child : items) {
            this.generate(child, indent + "  ");
        }
    }

    public static /* synthetic */ void generateLinks$default(ConsoleGenerator consoleGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        consoleGenerator.generateLinks(documentationNode, string);
    }

    @NotNull
    public final LanguageService getSignatureGenerator() {
        return this.signatureGenerator;
    }

    @NotNull
    public final LocationService getLocationService() {
        return this.locationService;
    }

    public ConsoleGenerator(@NotNull LanguageService signatureGenerator, @NotNull LocationService locationService) {
        Intrinsics.checkParameterIsNotNull(signatureGenerator, "signatureGenerator");
        Intrinsics.checkParameterIsNotNull(locationService, "locationService");
        this.signatureGenerator = signatureGenerator;
        this.locationService = locationService;
        this.IndentStep = "  ";
    }
}

