/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.DocumentationModule;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.DocumentationOptions;
import org.jetbrains.dokka.FileGeneratorKt;
import org.jetbrains.dokka.FileLocation;
import org.jetbrains.dokka.FileLocationService;
import org.jetbrains.dokka.FormatService;
import org.jetbrains.dokka.FormatServiceKt;
import org.jetbrains.dokka.Generator;
import org.jetbrains.dokka.OutlineFormatService;
import org.jetbrains.dokka.PackageListService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010%\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010&\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\b\u0010'\u001a\u00020!H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u0014@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001a@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/jetbrains/dokka/FileGenerator;", "Lorg/jetbrains/dokka/Generator;", "locationService", "Lorg/jetbrains/dokka/FileLocationService;", "(Lorg/jetbrains/dokka/FileLocationService;)V", "<set-?>", "Lorg/jetbrains/dokka/FormatService;", "formatService", "getFormatService", "()Lorg/jetbrains/dokka/FormatService;", "setFormatService", "(Lorg/jetbrains/dokka/FormatService;)V", "getLocationService", "()Lorg/jetbrains/dokka/FileLocationService;", "Lorg/jetbrains/dokka/DocumentationOptions;", "options", "getOptions", "()Lorg/jetbrains/dokka/DocumentationOptions;", "setOptions", "(Lorg/jetbrains/dokka/DocumentationOptions;)V", "Lorg/jetbrains/dokka/OutlineFormatService;", "outlineService", "getOutlineService", "()Lorg/jetbrains/dokka/OutlineFormatService;", "setOutlineService", "(Lorg/jetbrains/dokka/OutlineFormatService;)V", "Lorg/jetbrains/dokka/PackageListService;", "packageListService", "getPackageListService", "()Lorg/jetbrains/dokka/PackageListService;", "setPackageListService", "(Lorg/jetbrains/dokka/PackageListService;)V", "buildOutlines", "", "nodes", "", "Lorg/jetbrains/dokka/DocumentationNode;", "buildPackageList", "buildPages", "buildSupportFiles", "core"})
public final class FileGenerator
implements Generator {
    @Nullable
    private OutlineFormatService outlineService;
    @NotNull
    public FormatService formatService;
    @NotNull
    public DocumentationOptions options;
    @Nullable
    private PackageListService packageListService;
    @NotNull
    private final FileLocationService locationService;

    @Nullable
    public final OutlineFormatService getOutlineService() {
        return this.outlineService;
    }

    @Inject(optional=true)
    public final void setOutlineService(@Nullable OutlineFormatService outlineFormatService) {
        this.outlineService = outlineFormatService;
    }

    @NotNull
    public final FormatService getFormatService() {
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        return formatService;
    }

    @Inject(optional=true)
    public final void setFormatService(@NotNull FormatService formatService) {
        Intrinsics.checkParameterIsNotNull(formatService, "<set-?>");
        this.formatService = formatService;
    }

    @NotNull
    public final DocumentationOptions getOptions() {
        DocumentationOptions documentationOptions = this.options;
        if (documentationOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException("options");
        }
        return documentationOptions;
    }

    @Inject(optional=true)
    public final void setOptions(@NotNull DocumentationOptions documentationOptions) {
        Intrinsics.checkParameterIsNotNull(documentationOptions, "<set-?>");
        this.options = documentationOptions;
    }

    @Nullable
    public final PackageListService getPackageListService() {
        return this.packageListService;
    }

    @Inject(optional=true)
    public final void setPackageListService(@Nullable PackageListService packageListService) {
        this.packageListService = packageListService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void buildPages(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Object key$iv$iv;
        Map.Entry $receiver$iv$iv$iv;
        Object it;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        FileLocationService specificLocationService = this.locationService.withExtension(formatService.getExtension());
        Object $receiver$iv = nodes;
        Iterable<? extends DocumentationNode> iterable = $receiver$iv;
        Map.Entry destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            it = (DocumentationNode)element$iv$iv;
            boolean bl = false;
            $receiver$iv$iv$iv = destination$iv$iv;
            key$iv$iv = specificLocationService.location((DocumentationNode)it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        Iterator iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Map.Entry entry;
            Object element$iv$iv;
            destination$iv$iv = entry = iterator2.next();
            FileLocation location2 = (FileLocation)destination$iv$iv.getKey();
            destination$iv$iv = entry;
            List items = (List)destination$iv$iv.getValue();
            File file2 = location2.getFile();
            File file3 = file2.getParentFile();
            if (file3 != null) {
                FileGeneratorKt.access$mkdirsOrFail(file3);
            }
            try {
                Closeable closeable = new FileOutputStream(file2);
                element$iv$iv = null;
                try {
                    it = (FileOutputStream)closeable;
                    boolean bl = false;
                    key$iv$iv = new OutputStreamWriter((OutputStream)it, Charsets.UTF_8);
                    $receiver$iv$iv$iv = null;
                    try {
                        Object it2 = (OutputStreamWriter)key$iv$iv;
                        boolean bl2 = false;
                        FormatService formatService2 = this.formatService;
                        if (formatService2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("formatService");
                        }
                        ((Writer)it2).write(FormatServiceKt.format(formatService2, location2, items));
                        it2 = Unit.INSTANCE;
                    }
                    catch (Throwable it2) {
                        $receiver$iv$iv$iv = it2;
                        throw it2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)key$iv$iv, (Throwable)((Object)$receiver$iv$iv$iv));
                    }
                    it = Unit.INSTANCE;
                }
                catch (Throwable it3) {
                    element$iv$iv = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, element$iv$iv);
                }
            }
            catch (Throwable e) {
                System.out.println(e);
            }
            Iterable e = items;
            FileGenerator fileGenerator = this;
            element$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                DocumentationNode it4 = (DocumentationNode)element$iv$iv2;
                boolean bl = false;
                Iterable list$iv$iv = it4.getMembers();
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            fileGenerator.buildPages(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void buildOutlines(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Object it;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        OutlineFormatService outlineFormatService = this.outlineService;
        if (outlineFormatService == null) {
            return;
        }
        OutlineFormatService outlineService = outlineFormatService;
        Object $receiver$iv = nodes;
        Iterable<? extends DocumentationNode> iterable = $receiver$iv;
        Map.Entry destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            it = (DocumentationNode)element$iv$iv;
            boolean bl = false;
            Map.Entry $receiver$iv$iv$iv = destination$iv$iv;
            FileLocation key$iv$iv = this.locationService.location((DocumentationNode)it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        Iterator iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            destination$iv$iv = entry = iterator2.next();
            FileLocation location2 = (FileLocation)destination$iv$iv.getKey();
            destination$iv$iv = entry;
            List items = (List)destination$iv$iv.getValue();
            File file2 = outlineService.getOutlineFileName(location2);
            File file3 = file2.getParentFile();
            if (file3 != null) {
                FileGeneratorKt.access$mkdirsOrFail(file3);
            }
            Closeable closeable = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                it = (FileOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new OutputStreamWriter((OutputStream)it, Charsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    OutputStreamWriter it2 = (OutputStreamWriter)closeable2;
                    boolean bl2 = false;
                    it2.write(outlineService.formatOutline(location2, items));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    @Override
    public void buildSupportFiles() {
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        formatService.enumerateSupportFiles((Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(this){
            final /* synthetic */ FileGenerator this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String resource, @NotNull String targetPath) {
                Intrinsics.checkParameterIsNotNull(resource, "resource");
                Intrinsics.checkParameterIsNotNull(targetPath, "targetPath");
                Closeable closeable = new FileOutputStream(this.this$0.getLocationService().location(CollectionsKt.listOf(targetPath), false).getFile());
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = this.this$0.getClass().getResourceAsStream(resource);
                    Intrinsics.checkExpressionValueIsNotNull(inputStream, "javaClass.getResourceAsStream(resource)");
                    long l = ByteStreamsKt.copyTo$default(inputStream, it, 0, 2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            {
                this.this$0 = fileGenerator;
                super(2);
            }
        });
    }

    @Override
    public void buildPackageList(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        if (this.packageListService == null) {
            return;
        }
        for (DocumentationNode documentationNode : nodes) {
            File moduleRoot = this.locationService.location(documentationNode).getFile().getParentFile();
            File packageListFile = new File(moduleRoot, "package-list");
            StringBuilder stringBuilder = new StringBuilder().append("$dokka.format:");
            DocumentationOptions documentationOptions = this.options;
            if (documentationOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException("options");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(documentationOptions.getOutputFormat()).append('\n');
            PackageListService packageListService = this.packageListService;
            if (packageListService == null) {
                Intrinsics.throwNpe();
            }
            DocumentationNode documentationNode2 = documentationNode;
            if (documentationNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.dokka.DocumentationModule");
            }
            FilesKt.writeText$default(packageListFile, stringBuilder2.append(packageListService.formatPackageList((DocumentationModule)documentationNode2)).toString(), null, 2, null);
        }
    }

    @NotNull
    public final FileLocationService getLocationService() {
        return this.locationService;
    }

    @Inject
    public FileGenerator(@NotNull FileLocationService locationService) {
        Intrinsics.checkParameterIsNotNull(locationService, "locationService");
        this.locationService = locationService;
    }
}

