/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.ContentNodeDirectLink;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.HtmlFormatServiceKt;
import org.jetbrains.dokka.HtmlOutputBuilder;
import org.jetbrains.dokka.HtmlTemplateService;
import org.jetbrains.dokka.LanguageService;
import org.jetbrains.dokka.Location;
import org.jetbrains.dokka.LocationService;
import org.jetbrains.dokka.OutlineFormatService;
import org.jetbrains.dokka.StructuredFormatService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B1\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001a2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\"\u0010\u001d\u001a\u00020\u00122\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fH\u0016J\u001c\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\"\u001a\u00020\u00122\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/dokka/HtmlFormatService;", "Lorg/jetbrains/dokka/StructuredFormatService;", "Lorg/jetbrains/dokka/OutlineFormatService;", "locationService", "Lorg/jetbrains/dokka/LocationService;", "signatureGenerator", "Lorg/jetbrains/dokka/LanguageService;", "templateService", "Lorg/jetbrains/dokka/HtmlTemplateService;", "impliedPlatforms", "", "", "(Lorg/jetbrains/dokka/LocationService;Lorg/jetbrains/dokka/LanguageService;Lorg/jetbrains/dokka/HtmlTemplateService;Ljava/util/List;)V", "getImpliedPlatforms", "()Ljava/util/List;", "getTemplateService", "()Lorg/jetbrains/dokka/HtmlTemplateService;", "appendOutline", "", "location", "Lorg/jetbrains/dokka/Location;", "to", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodes", "", "Lorg/jetbrains/dokka/DocumentationNode;", "appendOutlineHeader", "node", "appendOutlineLevel", "body", "Lkotlin/Function0;", "createOutputBuilder", "Lorg/jetbrains/dokka/HtmlOutputBuilder;", "enumerateSupportFiles", "callback", "Lkotlin/Function2;", "getOutlineFileName", "Ljava/io/File;", "core"})
public class HtmlFormatService
extends StructuredFormatService
implements OutlineFormatService {
    @NotNull
    private final HtmlTemplateService templateService;
    @NotNull
    private final List<String> impliedPlatforms;

    @Override
    public void enumerateSupportFiles(@NotNull Function2<? super String, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        callback.invoke("/dokka/styles/style.css", "style.css");
    }

    @Override
    @NotNull
    public HtmlOutputBuilder createOutputBuilder(@NotNull StringBuilder to, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        return new HtmlOutputBuilder(to, location2, this.getLocationService(), this.getLanguageService(), this.getExtension(), this.impliedPlatforms, this.templateService);
    }

    @Override
    public void appendOutline(@NotNull Location location2, @NotNull StringBuilder to, @NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        this.templateService.appendHeader(to, "Module Contents", HtmlFormatServiceKt.access$calcPathToRoot(this.getLocationService(), location2));
        OutlineFormatService.DefaultImpls.appendOutline(this, location2, to, nodes);
        this.templateService.appendFooter(to);
    }

    @Override
    @NotNull
    public File getOutlineFileName(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        return new File(location2.getPath() + "-outline.html");
    }

    @Override
    public void appendOutlineHeader(@NotNull Location location2, @NotNull DocumentationNode node, @NotNull StringBuilder to) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(to, "to");
        ContentNodeDirectLink link2 = new ContentNodeDirectLink(node);
        link2.append(this.getLanguageService().render(node, LanguageService.RenderMode.FULL));
        StringBuilder tempBuilder = new StringBuilder();
        this.createOutputBuilder(tempBuilder, location2).appendContent(link2);
        StringBuilder stringBuilder = to;
        String string = "<a href=\"" + location2.getPath() + "\">" + tempBuilder.toString() + "</a><br/>";
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
    }

    @Override
    public void appendOutlineLevel(@NotNull StringBuilder to, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(body, "body");
        StringBuilder stringBuilder = to;
        String string = "<ul>";
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
        body.invoke();
        stringBuilder = to;
        string = "</ul>";
        StringBuilder stringBuilder3 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder3, "append(value)");
        StringsKt.appendln(stringBuilder3);
    }

    @NotNull
    public final HtmlTemplateService getTemplateService() {
        return this.templateService;
    }

    @NotNull
    public final List<String> getImpliedPlatforms() {
        return this.impliedPlatforms;
    }

    @Inject
    public HtmlFormatService(@Named(value="folders") @NotNull LocationService locationService, @NotNull LanguageService signatureGenerator, @NotNull HtmlTemplateService templateService, @Named(value="impliedPlatforms") @NotNull List<String> impliedPlatforms) {
        Intrinsics.checkParameterIsNotNull(locationService, "locationService");
        Intrinsics.checkParameterIsNotNull(signatureGenerator, "signatureGenerator");
        Intrinsics.checkParameterIsNotNull(templateService, "templateService");
        Intrinsics.checkParameterIsNotNull(impliedPlatforms, "impliedPlatforms");
        super(locationService, signatureGenerator, "html", null, 8, null);
        this.templateService = templateService;
        this.impliedPlatforms = impliedPlatforms;
    }

    @Override
    @NotNull
    public String formatOutline(@NotNull Location location2, @NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        return OutlineFormatService.DefaultImpls.formatOutline(this, location2, nodes);
    }
}

