/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.HtmlKt;
import org.jetbrains.dokka.LanguageService;
import org.jetbrains.dokka.ListKind;
import org.jetbrains.dokka.ListState;
import org.jetbrains.dokka.Location;
import org.jetbrains.dokka.LocationService;
import org.jetbrains.dokka.MarkdownFormatServiceKt;
import org.jetbrains.dokka.MarkdownOutputBuilder;
import org.jetbrains.dokka.StructuredOutputBuilder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0016J\u001e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\b\u0010(\u001a\u00020\"H\u0016J\u0016\u0010)\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u0010*\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u001e\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\b\u0010-\u001a\u00020\"H\u0016J\u001e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u00100\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\b\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020\"H\u0016J\u0016\u00103\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u00104\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u00105\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u00106\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J/\u00107\u001a\u00020\"2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f09\"\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u0010<\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0016\u0010=\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\u0010\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020\fH\u0016J\u0016\u0010@\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016J\b\u0010A\u001a\u00020\u0013H\u0002J\b\u0010B\u001a\u00020\"H\u0002J\b\u0010C\u001a\u00020\"H\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/dokka/MarkdownOutputBuilder;", "Lorg/jetbrains/dokka/StructuredOutputBuilder;", "to", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "location", "Lorg/jetbrains/dokka/Location;", "locationService", "Lorg/jetbrains/dokka/LocationService;", "languageService", "Lorg/jetbrains/dokka/LanguageService;", "extension", "", "impliedPlatforms", "", "(Ljava/lang/StringBuilder;Lorg/jetbrains/dokka/Location;Lorg/jetbrains/dokka/LocationService;Lorg/jetbrains/dokka/LanguageService;Ljava/lang/String;Ljava/util/List;)V", "backTickFindingRegex", "Lkotlin/text/Regex;", "inCodeBlock", "", "getInCodeBlock", "()Z", "setInCodeBlock", "(Z)V", "inTableCell", "getInTableCell", "setInTableCell", "lastTableCellStart", "", "listStack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/dokka/ListState;", "maxBackticksInCodeBlock", "appendAnchor", "", "anchor", "appendBlockCode", "language", "body", "Lkotlin/Function0;", "appendBreadcrumbSeparator", "appendCode", "appendEmphasis", "appendHeader", "level", "appendLine", "appendLink", "href", "appendListItem", "appendNewline", "appendNonBreakingSpace", "appendOrderedList", "appendParagraph", "appendStrikethrough", "appendStrong", "appendTable", "columns", "", "([Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "appendTableBody", "appendTableCell", "appendTableRow", "appendText", "text", "appendUnorderedList", "endsWithNewline", "ensureNewline", "ensureParagraph", "core"})
public class MarkdownOutputBuilder
extends StructuredOutputBuilder {
    private final ArrayDeque<ListState> listStack;
    private boolean inTableCell;
    private boolean inCodeBlock;
    private int lastTableCellStart;
    private int maxBackticksInCodeBlock;
    private final Regex backTickFindingRegex;

    protected final boolean getInTableCell() {
        return this.inTableCell;
    }

    protected final void setInTableCell(boolean bl) {
        this.inTableCell = bl;
    }

    protected final boolean getInCodeBlock() {
        return this.inCodeBlock;
    }

    protected final void setInCodeBlock(boolean bl) {
        this.inCodeBlock = bl;
    }

    private final void appendNewline() {
        while (StringsKt.endsWith$default((CharSequence)this.getTo(), ' ', false, 2, null)) {
            this.getTo().setLength(this.getTo().length() - 1);
        }
        StringsKt.appendln(this.getTo());
    }

    private final void ensureNewline() {
        if (this.inTableCell && this.listStack.isEmpty()) {
            if (this.getTo().length() != this.lastTableCellStart && !StringsKt.endsWith$default((CharSequence)this.getTo(), (CharSequence)"<br>", false, 2, null)) {
                this.getTo().append("<br>");
            }
        } else if (!this.endsWithNewline()) {
            this.appendNewline();
        }
    }

    private final boolean endsWithNewline() {
        for (int index2 = this.getTo().length() - 1; index2 > 0; --index2) {
            char c = this.getTo().charAt(index2);
            if (c == ' ') continue;
            return c == '\n';
        }
        return false;
    }

    @Override
    protected void ensureParagraph() {
        if (!StringsKt.endsWith$default((CharSequence)this.getTo(), (CharSequence)MarkdownFormatServiceKt.access$getTWO_LINE_BREAKS$p(), false, 2, null)) {
            if (!StringsKt.endsWith$default((CharSequence)this.getTo(), '\n', false, 2, null)) {
                this.appendNewline();
            }
            this.appendNewline();
        }
    }

    @Override
    public void appendBreadcrumbSeparator() {
        this.getTo().append(" / ");
    }

    @Override
    public void appendText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        if (this.inCodeBlock) {
            this.getTo().append(text2);
            Sequence backTicks = Regex.findAll$default(this.backTickFindingRegex, text2, 0, 2, null);
            Integer n = (Integer)SequencesKt.max(SequencesKt.map(backTicks, appendText.longestBackTickRun.1.INSTANCE));
            int longestBackTickRun2 = n != null ? n : 0;
            this.maxBackticksInCodeBlock = RangesKt.coerceAtLeast(this.maxBackticksInCodeBlock, longestBackTickRun2);
        } else if (Intrinsics.areEqual(text2, "\n") && this.inTableCell) {
            this.getTo().append(" ");
        } else {
            this.getTo().append(HtmlKt.htmlEscape(text2));
        }
    }

    @Override
    public void appendCode(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.inCodeBlock = true;
        int codeBlockStart = this.getTo().length();
        this.maxBackticksInCodeBlock = 0;
        this.wrapIfNotEmpty("`", "`", body, true);
        if (this.maxBackticksInCodeBlock > 0) {
            String extraBackticks = StringsKt.repeat("`", this.maxBackticksInCodeBlock);
            this.getTo().insert(codeBlockStart, extraBackticks);
            this.getTo().append(extraBackticks);
        }
        this.inCodeBlock = false;
    }

    @Override
    public void appendUnorderedList(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.listStack.push(new ListState(ListKind.Unordered, 0, 2, null));
        body.invoke();
        this.listStack.pop();
        this.ensureNewline();
    }

    @Override
    public void appendOrderedList(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.listStack.push(new ListState(ListKind.Ordered, 0, 2, null));
        body.invoke();
        this.listStack.pop();
        this.ensureNewline();
    }

    @Override
    public void appendListItem(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.ensureNewline();
        ListState listState = this.listStack.peek();
        this.getTo().append(listState != null ? listState.getTagAndIncrement() : null);
        body.invoke();
        this.ensureNewline();
    }

    @Override
    public void appendStrong(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.wrap("**", "**", body);
    }

    @Override
    public void appendEmphasis(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.wrap("*", "*", body);
    }

    @Override
    public void appendStrikethrough(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.wrap("~~", "~~", body);
    }

    @Override
    public void appendLink(@NotNull String href, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(href, "href");
        Intrinsics.checkParameterIsNotNull(body, "body");
        if (this.inCodeBlock) {
            this.wrap("`[`", "`](" + href + ")`", body);
        } else {
            this.wrap("[", "](" + href + ')', body);
        }
    }

    @Override
    public void appendLine() {
        if (this.inTableCell) {
            this.getTo().append("<br>");
        } else {
            this.appendNewline();
        }
    }

    @Override
    public void appendAnchor(@NotNull String anchor2) {
        Intrinsics.checkParameterIsNotNull(anchor2, "anchor");
    }

    @Override
    public void appendParagraph(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        if (this.inTableCell) {
            this.ensureNewline();
            body.invoke();
        } else {
            Collection collection = this.listStack;
            if (!collection.isEmpty()) {
                body.invoke();
                this.ensureNewline();
            } else {
                this.ensureParagraph();
                body.invoke();
                this.ensureParagraph();
            }
        }
    }

    @Override
    public void appendHeader(int level, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.ensureParagraph();
        this.getTo().append(StringsKt.repeat("#", level) + ' ');
        body.invoke();
        this.ensureParagraph();
    }

    @Override
    public void appendBlockCode(@NotNull String language, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(language, "language");
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.inCodeBlock = true;
        this.ensureParagraph();
        StringBuilder stringBuilder = this.getTo();
        CharSequence charSequence = language;
        charSequence = charSequence.length() == 0 ? "```" : "``` " + language;
        StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(value)");
        StringsKt.appendln(stringBuilder2);
        body.invoke();
        this.ensureNewline();
        stringBuilder = this.getTo();
        charSequence = "```";
        StringBuilder stringBuilder3 = stringBuilder.append((String)charSequence);
        Intrinsics.checkExpressionValueIsNotNull(stringBuilder3, "append(value)");
        StringsKt.appendln(stringBuilder3);
        this.appendLine();
        this.inCodeBlock = false;
    }

    @Override
    public void appendTable(@NotNull String[] columns, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(columns, "columns");
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.ensureParagraph();
        body.invoke();
        this.ensureParagraph();
    }

    @Override
    public void appendTableBody(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        body.invoke();
    }

    @Override
    public void appendTableRow(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.getTo().append("|");
        body.invoke();
        this.appendNewline();
    }

    @Override
    public void appendTableCell(@NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.getTo().append(" ");
        this.inTableCell = true;
        this.lastTableCellStart = this.getTo().length();
        body.invoke();
        this.inTableCell = false;
        this.getTo().append(" |");
    }

    @Override
    public void appendNonBreakingSpace() {
        if (this.inCodeBlock) {
            this.getTo().append(" ");
        } else {
            this.getTo().append("&nbsp;");
        }
    }

    public MarkdownOutputBuilder(@NotNull StringBuilder to, @NotNull Location location2, @NotNull LocationService locationService, @NotNull LanguageService languageService, @NotNull String extension, @NotNull List<String> impliedPlatforms) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(locationService, "locationService");
        Intrinsics.checkParameterIsNotNull(languageService, "languageService");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        Intrinsics.checkParameterIsNotNull(impliedPlatforms, "impliedPlatforms");
        super(to, location2, locationService, languageService, extension, impliedPlatforms);
        this.listStack = new ArrayDeque();
        this.lastTableCellStart = -1;
        String string = "(`+)";
        MarkdownOutputBuilder markdownOutputBuilder = this;
        markdownOutputBuilder.backTickFindingRegex = regex = new Regex(string);
    }
}

