/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.Content;
import org.jetbrains.dokka.ContentBlock;
import org.jetbrains.dokka.ContentBuilderKt;
import org.jetbrains.dokka.ContentExternalLink;
import org.jetbrains.dokka.DeclarationLinkResolver;
import org.jetbrains.dokka.DokkaLogger;
import org.jetbrains.dokka.LinkResolver;
import org.jetbrains.dokka.MarkdownNode;
import org.jetbrains.dokka.MarkdownProcessorKt;
import org.jetbrains.dokka.MutableContent;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ&\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/dokka/PackageDocs;", "", "linkResolver", "Lorg/jetbrains/dokka/DeclarationLinkResolver;", "logger", "Lorg/jetbrains/dokka/DokkaLogger;", "(Lorg/jetbrains/dokka/DeclarationLinkResolver;Lorg/jetbrains/dokka/DokkaLogger;)V", "_packageContent", "", "", "Lorg/jetbrains/dokka/MutableContent;", "getLinkResolver", "()Lorg/jetbrains/dokka/DeclarationLinkResolver;", "getLogger", "()Lorg/jetbrains/dokka/DokkaLogger;", "moduleContent", "getModuleContent", "()Lorg/jetbrains/dokka/MutableContent;", "packageContent", "", "Lorg/jetbrains/dokka/Content;", "getPackageContent", "()Ljava/util/Map;", "findOrCreatePackageContent", "packageName", "findTargetContent", "heading", "parse", "", "fileName", "linkResolveContext", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "resolveContentLink", "Lorg/jetbrains/dokka/ContentBlock;", "href", "core"})
public final class PackageDocs {
    @NotNull
    private final MutableContent moduleContent;
    private final Map<String, MutableContent> _packageContent;
    @Nullable
    private final DeclarationLinkResolver linkResolver;
    @NotNull
    private final DokkaLogger logger;

    @NotNull
    public final MutableContent getModuleContent() {
        return this.moduleContent;
    }

    @NotNull
    public final Map<String, Content> getPackageContent() {
        return this._packageContent;
    }

    /*
     * WARNING - void declaration
     */
    public final void parse(@NotNull String fileName, @NotNull List<? extends PackageFragmentDescriptor> linkResolveContext) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        Intrinsics.checkParameterIsNotNull(linkResolveContext, "linkResolveContext");
        File file2 = new File(fileName);
        if (file2.exists()) {
            String text2 = FilesKt.readText$default(file2, null, 1, null);
            MarkdownNode tree = MarkdownProcessorKt.parseMarkdown(text2);
            LinkMap linkMap = LinkMap.Builder.buildLinkMap(tree.getNode(), text2);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.moduleContent;
            Iterable $receiver$iv = tree.getChildren();
            for (Object element$iv : $receiver$iv) {
                void targetContent;
                MarkdownNode it = (MarkdownNode)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getType(), MarkdownElementTypes.ATX_1)) {
                    MarkdownNode markdownNode = it.child(MarkdownTokenTypes.ATX_CONTENT);
                    String headingText = markdownNode != null ? markdownNode.getText() : null;
                    if (headingText == null) continue;
                    String string = headingText;
                    PackageDocs packageDocs = this;
                    void var16_16 = targetContent;
                    String string2 = ((Object)StringsKt.trimStart((CharSequence)string)).toString();
                    var16_16.element = packageDocs.findTargetContent(string2);
                    continue;
                }
                ContentBuilderKt.buildContentTo(it, (MutableContent)targetContent.element, new LinkResolver(linkMap, (Function1<? super String, ? extends ContentBlock>)new Function1<String, ContentBlock>(this, (Ref.ObjectRef)targetContent, linkMap, fileName, linkResolveContext){
                    final /* synthetic */ PackageDocs this$0;
                    final /* synthetic */ Ref.ObjectRef $targetContent$inlined;
                    final /* synthetic */ LinkMap $linkMap$inlined;
                    final /* synthetic */ String $fileName$inlined;
                    final /* synthetic */ List $linkResolveContext$inlined;
                    {
                        this.this$0 = packageDocs;
                        this.$targetContent$inlined = objectRef;
                        this.$linkMap$inlined = linkMap;
                        this.$fileName$inlined = string;
                        this.$linkResolveContext$inlined = list2;
                        super(1);
                    }

                    @NotNull
                    public final ContentBlock invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return PackageDocs.access$resolveContentLink(this.this$0, this.$fileName$inlined, it, this.$linkResolveContext$inlined);
                    }
                }));
            }
        } else {
            this.logger.warn("Include file " + file2 + " was not found.");
        }
    }

    private final MutableContent findTargetContent(String heading) {
        if (StringsKt.startsWith$default(heading, "Module", false, 2, null) || StringsKt.startsWith$default(heading, "module", false, 2, null)) {
            return this.moduleContent;
        }
        if (StringsKt.startsWith$default(heading, "Package", false, 2, null) || StringsKt.startsWith$default(heading, "package", false, 2, null)) {
            String string;
            String string2 = heading;
            int n = "package".length();
            PackageDocs packageDocs = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
            String string5 = string2 = (string = string4);
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            return packageDocs.findOrCreatePackageContent(string);
        }
        return this.findOrCreatePackageContent(heading);
    }

    /*
     * WARNING - void declaration
     */
    private final MutableContent findOrCreatePackageContent(String packageName) {
        MutableContent mutableContent;
        Map<String, MutableContent> $receiver$iv = this._packageContent;
        MutableContent value$iv = $receiver$iv.get(packageName);
        if (value$iv == null) {
            boolean bl = false;
            MutableContent answer$iv = new MutableContent();
            $receiver$iv.put(packageName, answer$iv);
            mutableContent = answer$iv;
        } else {
            void var3_3;
            mutableContent = var3_3;
        }
        return mutableContent;
    }

    private final ContentBlock resolveContentLink(String fileName, String href, List<? extends PackageFragmentDescriptor> linkResolveContext) {
        if (this.linkResolver != null) {
            ContentBlock contentBlock = (ContentBlock)SequencesKt.firstOrNull(SequencesKt.filterNotNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)linkResolveContext), (Function1)new Function1<PackageFragmentDescriptor, ContentBlock>(this, href){
                final /* synthetic */ PackageDocs this$0;
                final /* synthetic */ String $href;

                @Nullable
                public final ContentBlock invoke(@NotNull PackageFragmentDescriptor p) {
                    Intrinsics.checkParameterIsNotNull(p, "p");
                    return this.this$0.getLinkResolver().tryResolveContentLink(p, this.$href);
                }
                {
                    this.this$0 = packageDocs;
                    this.$href = string;
                    super(1);
                }
            })));
            if (contentBlock != null) {
                ContentBlock contentBlock2;
                ContentBlock it = contentBlock2 = contentBlock;
                boolean bl = false;
                return it;
            }
        }
        this.logger.warn("Unresolved link to `" + href + "` in include (" + fileName + ')');
        return new ContentExternalLink("#");
    }

    @Nullable
    public final DeclarationLinkResolver getLinkResolver() {
        return this.linkResolver;
    }

    @NotNull
    public final DokkaLogger getLogger() {
        return this.logger;
    }

    @Inject
    public PackageDocs(@Nullable DeclarationLinkResolver linkResolver, @NotNull DokkaLogger logger) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.linkResolver = linkResolver;
        this.logger = logger;
        this.moduleContent = new MutableContent();
        PackageDocs packageDocs = this;
        HashMap hashMap = new HashMap();
        packageDocs._packageContent = hashMap;
    }

    public static final /* synthetic */ ContentBlock access$resolveContentLink(PackageDocs $this, String fileName, String href, List linkResolveContext) {
        return $this.resolveContentLink(fileName, href, linkResolveContext);
    }
}

