/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.RegExFormatter;
import com.intellij.codeInspection.ui.RegExInputVerifier;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public class ClassHasNoToStringMethodInspection
extends AbstractToStringInspection {
    public String excludeClassNames = "";
    private Pattern excludeClassNamesPattern;
    public boolean excludeException = true;
    public boolean excludeDeprecated = true;
    public boolean excludeEnum;
    public boolean excludeAbstract;
    public boolean excludeTestCode;
    public boolean excludeInnerClasses;

    public ClassHasNoToStringMethodInspection() {
        try {
            this.excludeClassNamesPattern = Pattern.compile(this.excludeClassNames);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Class does not override 'toString()' method" == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(0);
        }
        return "Class does not override 'toString()' method";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("ClassHasNoToStringMethod" == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(1);
        }
        return "ClassHasNoToStringMethod";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitClass(PsiClass clazz) {
                PsiMethod[] superMethods;
                PsiMethod[] toStringMethods;
                PsiField[] fields2;
                PsiIdentifier nameIdentifier;
                if (AbstractToStringInspection.log.isDebugEnabled()) {
                    AbstractToStringInspection.log.debug("checkClass: clazz=" + clazz);
                }
                if ((nameIdentifier = clazz.getNameIdentifier()) == null || clazz.getName() == null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeException && InheritanceUtil.isInheritor(clazz, "java.lang.Throwable")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeDeprecated && clazz.isDeprecated()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeEnum && clazz.isEnum()) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeAbstract && clazz.hasModifierProperty("abstract")) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeTestCode && TestFrameworks.getInstance().isTestClass(clazz)) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeInnerClasses && clazz.getContainingClass() != null) {
                    return;
                }
                if (ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern != null) {
                    try {
                        String name = clazz.getName();
                        if (name != null && ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern.matcher(name).matches()) {
                            return;
                        }
                    }
                    catch (PatternSyntaxException name) {
                        // empty catch block
                    }
                }
                if ((fields2 = clazz.getFields()).length == 0) {
                    return;
                }
                fields2 = GenerateToStringUtils.filterAvailableFields(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                PsiMethod[] methods2 = null;
                if (GenerateToStringContext.getConfig().isEnableMethods()) {
                    methods2 = GenerateToStringUtils.filterAvailableMethods(clazz, GenerateToStringContext.getConfig().getFilterPattern());
                }
                if (Math.max(fields2.length, methods2 == null ? 0 : methods2.length) == 0) {
                    return;
                }
                for (PsiMethod method : toStringMethods = clazz.findMethodsByName("toString", false)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (parameterList.getParametersCount() != 0) continue;
                    return;
                }
                for (PsiMethod method : superMethods = clazz.findMethodsByName("toString", true)) {
                    PsiParameterList parameterList = method.getParameterList();
                    if (parameterList.getParametersCount() != 0 || !method.hasModifierProperty("final")) continue;
                    return;
                }
                holder.registerProblem((PsiElement)nameIdentifier, "Class '" + clazz.getName() + "' does not override 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(holder));
            }
        };
        if (javaElementVisitor == null) {
            ClassHasNoToStringMethodInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)new JLabel("Exclude classes (reg exp):"), constraints);
        final JFormattedTextField excludeClassNamesField = new JFormattedTextField(new RegExFormatter());
        excludeClassNamesField.setValue(this.excludeClassNamesPattern);
        excludeClassNamesField.setColumns(25);
        excludeClassNamesField.setInputVerifier(new RegExInputVerifier());
        excludeClassNamesField.setFocusLostBehavior(0);
        excludeClassNamesField.setMinimumSize(excludeClassNamesField.getPreferredSize());
        UIUtil.fixFormattedField(excludeClassNamesField);
        Document document = excludeClassNamesField.getDocument();
        document.addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(DocumentEvent e) {
                try {
                    excludeClassNamesField.commitEdit();
                    ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern = (Pattern)excludeClassNamesField.getValue();
                    ClassHasNoToStringMethodInspection.this.excludeClassNames = ClassHasNoToStringMethodInspection.this.excludeClassNamesPattern.pattern();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel.add((Component)excludeClassNamesField, constraints);
        CheckBox excludeExceptionCheckBox = new CheckBox("Ignore exception classes", this, "excludeException");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)excludeExceptionCheckBox, constraints);
        CheckBox excludeDeprecatedCheckBox = new CheckBox("Ignore deprecated classes", this, "excludeDeprecated");
        constraints.gridy = 2;
        panel.add((Component)excludeDeprecatedCheckBox, constraints);
        CheckBox excludeEnumCheckBox = new CheckBox("Ignore enum classes", this, "excludeEnum");
        constraints.gridy = 3;
        panel.add((Component)excludeEnumCheckBox, constraints);
        CheckBox excludeAbstractCheckBox = new CheckBox("Ignore abstract classes", this, "excludeAbstract");
        constraints.gridy = 4;
        panel.add((Component)excludeAbstractCheckBox, constraints);
        CheckBox excludeInTestCodeCheckBox = new CheckBox("Ignore test classes", this, "excludeTestCode");
        constraints.gridy = 5;
        panel.add((Component)excludeInTestCodeCheckBox, constraints);
        CheckBox excludeInnerClasses = new CheckBox("Ignore inner classes", this, "excludeInnerClasses");
        constraints.gridy = 6;
        constraints.weighty = 1.0;
        panel.add((Component)excludeInnerClasses, constraints);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/inspection/ClassHasNoToStringMethodInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

