/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.descriptors.FileClassDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmPropertyDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.descriptors.UtilKt;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.descriptors.FileClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/descriptors/SpecialDescriptorsFactory;", "", "psiSourceManager", "Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/psi2ir/PsiSourceManager;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "innerClassConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "outerThisDescriptors", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "singletonFieldDescriptors", "createEnumEntryFieldDescriptor", "enumEntryDescriptor", "createFileClassDescriptor", "Lorg/jetbrains/kotlin/codegen/descriptors/FileClassDescriptor;", "fileEntry", "Lorg/jetbrains/kotlin/ir/SourceManager$FileEntry;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "createInnerClassConstructorWithOuterThisParameter", "oldDescriptor", "createObjectInstanceFieldDescriptor", "objectDescriptor", "getFieldDescriptorForEnumEntry", "getFieldDescriptorForObjectInstance", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getOuterThisFieldDescriptor", "innerClassDescriptor", "backend"})
public final class SpecialDescriptorsFactory {
    private final HashMap<ClassDescriptor, PropertyDescriptor> singletonFieldDescriptors;
    private final HashMap<ClassDescriptor, PropertyDescriptor> outerThisDescriptors;
    private final HashMap<ClassConstructorDescriptor, ClassConstructorDescriptor> innerClassConstructors;
    private final PsiSourceManager psiSourceManager;
    private final KotlinBuiltIns builtIns;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PropertyDescriptor getFieldDescriptorForEnumEntry(@NotNull ClassDescriptor enumEntryDescriptor) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkParameterIsNotNull(enumEntryDescriptor, "enumEntryDescriptor");
        Map $receiver$iv = this.singletonFieldDescriptors;
        Object value$iv = $receiver$iv.get(enumEntryDescriptor);
        if (value$iv == null) {
            PropertyDescriptor answer$iv = this.createEnumEntryFieldDescriptor(enumEntryDescriptor);
            $receiver$iv.put(enumEntryDescriptor, answer$iv);
            propertyDescriptor = answer$iv;
        } else {
            void var3_3;
            propertyDescriptor = var3_3;
        }
        return propertyDescriptor;
    }

    @NotNull
    public final FileClassDescriptor createFileClassDescriptor(@NotNull SourceManager.FileEntry fileEntry, @NotNull PackageFragmentDescriptor packageFragment) {
        Intrinsics.checkParameterIsNotNull(fileEntry, "fileEntry");
        Intrinsics.checkParameterIsNotNull(packageFragment, "packageFragment");
        KtFile ktFile = this.psiSourceManager.getKtFile((PsiSourceManager.PsiFileEntry)fileEntry);
        if (ktFile == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected file entry: " + fileEntry)));
        }
        KtFile ktFile2 = ktFile;
        JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile2);
        KotlinSourceElement sourceElement = new KotlinSourceElement(ktFile2);
        Name name = fileClassInfo.getFileClassFqName().shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "fileClassInfo.fileClassFqName.shortName()");
        return new FileClassDescriptorImpl(name, packageFragment, CollectionsKt.listOf(this.builtIns.getAnyType()), sourceElement, Annotations.Companion.getEMPTY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PropertyDescriptor getOuterThisFieldDescriptor(@NotNull ClassDescriptor innerClassDescriptor) {
        PropertyDescriptorImpl propertyDescriptorImpl;
        Intrinsics.checkParameterIsNotNull(innerClassDescriptor, "innerClassDescriptor");
        if (!innerClassDescriptor.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + innerClassDescriptor)));
        }
        Map $receiver$iv = this.outerThisDescriptors;
        Object value$iv = $receiver$iv.get(innerClassDescriptor);
        if (value$iv == null) {
            ClassDescriptor classDescriptor = DescriptorUtils.getContainingClass(innerClassDescriptor);
            if (classDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + innerClassDescriptor)));
            }
            ClassDescriptor outerClassDescriptor = classDescriptor;
            Name name = Name.identifier("this$0");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"this$0\")");
            ClassDescriptor classDescriptor2 = outerClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "outerClassDescriptor");
            SimpleType simpleType2 = classDescriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "outerClassDescriptor.defaultType");
            KotlinType kotlinType = simpleType2;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Visibility visibility = JavaVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "JavaVisibilities.PACKAGE_VISIBILITY");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
            PropertyDescriptorImpl answer$iv = JvmPropertyDescriptorImpl.Companion.createFinalField(name, kotlinType, innerClassDescriptor, annotations2, visibility, 4096, sourceElement);
            $receiver$iv.put(innerClassDescriptor, answer$iv);
            propertyDescriptorImpl = answer$iv;
        } else {
            void var3_3;
            propertyDescriptorImpl = var3_3;
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    public final ClassConstructorDescriptor getInnerClassConstructorWithOuterThisParameter(@NotNull ClassConstructorDescriptor innerClassConstructor) {
        Object object;
        Intrinsics.checkParameterIsNotNull(innerClassConstructor, "innerClassConstructor");
        ClassDescriptor innerClass = innerClassConstructor.getContainingDeclaration();
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            String string = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map $receiver$iv = this.innerClassConstructors;
        Object value$iv = $receiver$iv.get(innerClassConstructor);
        if (value$iv == null) {
            ClassConstructorDescriptor answer$iv = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            $receiver$iv.put(innerClassConstructor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClassConstructorDescriptor)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassConstructorDescriptor createInnerClassConstructorWithOuterThisParameter(ClassConstructorDescriptor oldDescriptor) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassConstructorDescriptorImpl newDescriptor2;
        ClassDescriptor classDescriptor = oldDescriptor.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        SimpleType outerThisType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = newDescriptor2 = ClassConstructorDescriptorImpl.createSynthesized(classDescriptor, oldDescriptor.getAnnotations(), oldDescriptor.isPrimary(), oldDescriptor.getSource());
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptorImpl, "newDescriptor");
        CallableMemberDescriptor callableMemberDescriptor = classConstructorDescriptorImpl;
        SimpleType simpleType2 = outerThisType;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "outerThisType");
        ValueParameterDescriptor outerThisValueParameter = UtilKt.createValueParameter(callableMemberDescriptor, 0, "$outer", simpleType2);
        Collection collection2 = CollectionsKt.listOf(outerThisValueParameter);
        List<ValueParameterDescriptor> list2 = oldDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "oldDescriptor.valueParameters");
        Iterable iterable = list2;
        Collection collection3 = collection2;
        void var8_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            CallableDescriptor callableDescriptor = newDescriptor2;
            void v7 = it;
            Intrinsics.checkExpressionValueIsNotNull(v7, "it");
            Name name = v7.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor, name, it.getIndex() + 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        List<ValueParameterDescriptor> newValueParameters = CollectionsKt.plus(collection3, (Iterable)collection);
        newDescriptor2.initialize(newValueParameters, oldDescriptor.getVisibility());
        newDescriptor2.setReturnType(oldDescriptor.getReturnType());
        return newDescriptor2;
    }

    private final PropertyDescriptor createEnumEntryFieldDescriptor(ClassDescriptor enumEntryDescriptor) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = enumEntryDescriptor.getKind() == ClassKind.ENUM_ENTRY;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Should be enum entry: " + enumEntryDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor enumClassDescriptor = (ClassDescriptor)declarationDescriptor;
        boolean bl4 = bl = enumClassDescriptor.getKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string = "Should be enum class: " + enumClassDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Name name = enumEntryDescriptor.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "enumEntryDescriptor.name");
        SimpleType simpleType2 = enumClassDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "enumClassDescriptor.defaultType");
        KotlinType kotlinType = simpleType2;
        DeclarationDescriptor declarationDescriptor2 = enumClassDescriptor;
        Annotations annotations2 = enumEntryDescriptor.getAnnotations();
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PUBLIC");
        SourceElement sourceElement = enumEntryDescriptor.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "enumEntryDescriptor.source");
        return JvmPropertyDescriptorImpl.Companion.createStaticVal(name, kotlinType, declarationDescriptor2, annotations2, Modality.FINAL, visibility, 16384, sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PropertyDescriptor getFieldDescriptorForObjectInstance(@NotNull ClassDescriptor objectDescriptor) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkParameterIsNotNull(objectDescriptor, "objectDescriptor");
        Map $receiver$iv = this.singletonFieldDescriptors;
        Object value$iv = $receiver$iv.get(objectDescriptor);
        if (value$iv == null) {
            PropertyDescriptor answer$iv = this.createObjectInstanceFieldDescriptor(objectDescriptor);
            $receiver$iv.put(objectDescriptor, answer$iv);
            propertyDescriptor = answer$iv;
        } else {
            void var3_3;
            propertyDescriptor = var3_3;
        }
        return propertyDescriptor;
    }

    private final PropertyDescriptor createObjectInstanceFieldDescriptor(ClassDescriptor objectDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Name name;
        boolean bl;
        boolean bl2 = bl = objectDescriptor.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Should be an object: " + objectDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean isNotMappedCompanion = objectDescriptor.isCompanionObject() && !CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(objectDescriptor);
        Name name2 = name = isNotMappedCompanion ? objectDescriptor.getName() : Name.identifier("INSTANCE");
        if (isNotMappedCompanion) {
            DeclarationDescriptor declarationDescriptor2 = objectDescriptor.getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "objectDescriptor.containingDeclaration");
        } else {
            declarationDescriptor = objectDescriptor;
        }
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.PUBLIC, false, name, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE, false, false, false, false, false, false);
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptorImpl, "PropertyDescriptorImpl.c\u2026ated = */ false\n        )");
        SimpleType simpleType2 = objectDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "objectDescriptor.defaultType");
        return UtilKt.initialize$default(propertyDescriptorImpl, simpleType2, null, null, null, null, null, 62, null);
    }

    public SpecialDescriptorsFactory(@NotNull PsiSourceManager psiSourceManager, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(psiSourceManager, "psiSourceManager");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.psiSourceManager = psiSourceManager;
        this.builtIns = builtIns;
        this.singletonFieldDescriptors = new HashMap();
        this.outerThisDescriptors = new HashMap();
        this.innerClassConstructors = new HashMap();
    }
}

