/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ImplicitReceiversUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t\u001a\n\u0010\f\u001a\u00020\u0003*\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"getAllAccessibleFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getAllAccessibleVariables", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getFileResolutionScope", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getResolutionScope", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/psi/KtElement;", "getVariableFromImplicitReceivers", "getVariablesFromImplicitReceivers", "ide-common"})
@JvmName(name="ScopeUtils")
public final class ScopeUtils {
    @NotNull
    public static final Collection<VariableDescriptor> getAllAccessibleVariables(@NotNull LexicalScope $receiver, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(name, "name");
        return CollectionsKt.plus(ScopeUtils.getVariablesFromImplicitReceivers($receiver, name), (Iterable)ScopeUtilsKt.collectVariables($receiver, name, NoLookupLocation.FROM_IDE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FunctionDescriptor> getAllAccessibleFunctions(@NotNull LexicalScope $receiver, @NotNull Name name) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Iterable iterable = $receiver$iv = (Iterable)ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv$iv;
            Iterable list$iv$iv = it.getType().getMemberScope().getContributedFunctions(name, NoLookupLocation.FROM_IDE);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)ScopeUtilsKt.collectFunctions($receiver, name, NoLookupLocation.FROM_IDE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<VariableDescriptor> getVariablesFromImplicitReceivers(@NotNull LexicalScope $receiver, @NotNull Name name) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Iterable iterable = $receiver$iv = (Iterable)ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv$iv;
            Iterable list$iv$iv = it.getType().getMemberScope().getContributedVariables(name, NoLookupLocation.FROM_IDE);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final VariableDescriptor getVariableFromImplicitReceivers(@NotNull LexicalScope $receiver, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Iterable $receiver$iv = ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        for (Object element$iv : $receiver$iv) {
            PropertyDescriptor propertyDescriptor;
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)it.getType().getMemberScope().getContributedVariables(name, NoLookupLocation.FROM_IDE));
            if (propertyDescriptor2 == null) continue;
            PropertyDescriptor it2 = propertyDescriptor = propertyDescriptor2;
            return it2;
        }
        return null;
    }

    @Nullable
    public static final LexicalScope getResolutionScope(@NotNull PsiElement $receiver, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf($receiver).iterator();
        while (iterator2.hasNext()) {
            LexicalScope scope;
            PsiElement parent2 = iterator2.next();
            if (parent2 instanceof KtElement && (scope = (LexicalScope)bindingContext.get(BindingContext.LEXICAL_SCOPE, parent2)) != null) {
                return scope;
            }
            if (parent2 instanceof KtClassBody) {
                ClassDescriptorWithResolutionScopes classDescriptor;
                Object v = bindingContext.get(BindingContext.CLASS, parent2.getParent());
                if (!(v instanceof ClassDescriptorWithResolutionScopes)) {
                    v = null;
                }
                if ((classDescriptor = (ClassDescriptorWithResolutionScopes)v) != null) {
                    return classDescriptor.getScopeForMemberDeclarationResolution();
                }
            }
            if (!(parent2 instanceof KtFile)) continue;
            break;
        }
        return null;
    }

    @NotNull
    public static final LexicalScope getResolutionScope(@NotNull PsiElement $receiver, @NotNull BindingContext bindingContext, @NotNull ResolutionFacade resolutionFacade) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(resolutionFacade, "resolutionFacade");
        LexicalScope lexicalScope = ScopeUtils.getResolutionScope($receiver, bindingContext);
        if (lexicalScope == null) {
            PsiFile psiFile = $receiver.getContainingFile();
            if (psiFile instanceof KtFile) {
                PsiFile psiFile2 = $receiver.getContainingFile();
                if (psiFile2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                lexicalScope = ScopeUtils.getFileResolutionScope(resolutionFacade, (KtFile)psiFile2);
            } else {
                String string = "Not in KtFile";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return lexicalScope;
    }

    @NotNull
    public static final LexicalScope getResolutionScope(@NotNull KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade($receiver);
        BindingContext context = resolutionFacade.analyze($receiver, BodyResolveMode.FULL);
        return ScopeUtils.getResolutionScope($receiver, context, resolutionFacade);
    }

    @NotNull
    public static final LexicalScope getFileResolutionScope(@NotNull ResolutionFacade $receiver, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(file2, "file");
        ResolutionFacade $receiver$iv = $receiver;
        return $receiver$iv.getFrontendService(FileScopeProvider.class).getFileResolutionScope(file2);
    }
}

