/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.ConstantEvaluator$WhenMappings;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaField;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ConstantEvaluator;", "", "containingClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "evaluateBinaryExpression", "value", "Lcom/sun/tools/javac/tree/JCTree$JCBinary;", "evaluateUnaryExpression", "Lcom/sun/tools/javac/tree/JCTree$JCUnary;", "evaluateValue", "lhsValue", "rhsValue", "opcode", "Lcom/sun/tools/javac/tree/JCTree$Tag;", "getValue", "expr", "Lcom/sun/tools/javac/tree/JCTree$JCExpression;", "cli"})
public final class ConstantEvaluator {
    private final JavaClass containingClass;
    private final JavacWrapper javac;
    private final CompilationUnitTree compilationUnit;

    @Nullable
    public final Object getValue(@NotNull JCTree.JCExpression expr) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expr, "expr");
        JCTree.JCExpression jCExpression = expr;
        if (jCExpression instanceof JCTree.JCLiteral) {
            object = ((JCTree.JCLiteral)expr).typetag == TypeTag.BOOLEAN ? Boolean.valueOf(Intrinsics.areEqual(((JCTree.JCLiteral)expr).value, (Object)0) ^ true) : ((JCTree.JCLiteral)expr).value;
        } else if (jCExpression instanceof JCTree.JCIdent || jCExpression instanceof JCTree.JCFieldAccess) {
            JavaField javaField2 = this.javac.resolveField(expr, this.compilationUnit, this.containingClass);
            object = javaField2 != null ? javaField2.getInitializerValue() : null;
        } else if (jCExpression instanceof JCTree.JCBinary) {
            object = this.evaluateBinaryExpression((JCTree.JCBinary)expr);
        } else if (jCExpression instanceof JCTree.JCParens) {
            JCTree.JCExpression jCExpression2 = ((JCTree.JCParens)expr).expr;
            Intrinsics.checkExpressionValueIsNotNull(jCExpression2, "expr.expr");
            object = this.getValue(jCExpression2);
        } else {
            object = jCExpression instanceof JCTree.JCUnary ? this.evaluateUnaryExpression((JCTree.JCUnary)expr) : null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object evaluateUnaryExpression(JCTree.JCUnary value) {
        JCTree.JCExpression jCExpression = value.arg;
        Intrinsics.checkExpressionValueIsNotNull(jCExpression, "value.arg");
        Object argValue = this.getValue(jCExpression);
        JCTree.Tag tag = value.getTag();
        if (tag == null) return null;
        switch (ConstantEvaluator$WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1: {
                Constable constable;
                Object object = argValue;
                if (object instanceof Integer) {
                    constable = ~((Number)argValue).intValue();
                    return constable;
                }
                if (object instanceof Long) {
                    constable = ((Number)argValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    return constable;
                }
                if (object instanceof Short) {
                    short s = ((Number)argValue).shortValue();
                    constable = ~s;
                    return constable;
                }
                if (!(object instanceof Byte)) return null;
                byte by = ((Number)argValue).byteValue();
                constable = ~by;
                return constable;
            }
            case 2: {
                Object object = argValue;
                if (!(object instanceof Boolean)) {
                    object = null;
                }
                Boolean bl = (Boolean)object;
                if (bl == null) return null;
                Boolean bl2 = bl;
                boolean it = bl2;
                Constable constable = Boolean.valueOf(!it);
                return constable;
            }
            default: {
                return null;
            }
        }
    }

    private final Object evaluateBinaryExpression(JCTree.JCBinary value) {
        JCTree.JCExpression jCExpression = value.lhs;
        Intrinsics.checkExpressionValueIsNotNull(jCExpression, "value.lhs");
        Object object = this.getValue(jCExpression);
        if (object == null) {
            return null;
        }
        Object lhsValue = object;
        JCTree.JCExpression jCExpression2 = value.rhs;
        Intrinsics.checkExpressionValueIsNotNull(jCExpression2, "value.rhs");
        Object object2 = this.getValue(jCExpression2);
        if (object2 == null) {
            return null;
        }
        Object rhsValue = object2;
        JCTree.Tag tag = value.getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)tag, "value.tag");
        return this.evaluateValue(lhsValue, rhsValue, tag);
    }

    private final Object evaluateValue(Object lhsValue, Object rhsValue, JCTree.Tag opcode) {
        if (lhsValue instanceof String && opcode == JCTree.Tag.PLUS) {
            return (String)lhsValue + rhsValue;
        }
        if (lhsValue instanceof Boolean && rhsValue instanceof Boolean) {
            Boolean bl;
            switch (ConstantEvaluator$WhenMappings.$EnumSwitchMapping$1[opcode.ordinal()]) {
                case 1: {
                    bl = (Boolean)lhsValue != false && (Boolean)rhsValue != false;
                    break;
                }
                case 2: {
                    bl = (Boolean)lhsValue != false || (Boolean)rhsValue != false;
                    break;
                }
                case 3: {
                    bl = Intrinsics.areEqual(lhsValue, rhsValue);
                    break;
                }
                case 4: {
                    bl = Intrinsics.areEqual(lhsValue, rhsValue) ^ true;
                    break;
                }
                case 5: {
                    bl = (Boolean)lhsValue ^ (Boolean)rhsValue;
                    break;
                }
                case 6: {
                    bl = (Boolean)lhsValue & (Boolean)rhsValue;
                    break;
                }
                case 7: {
                    bl = (Boolean)lhsValue | (Boolean)rhsValue;
                    break;
                }
                default: {
                    bl = null;
                }
            }
            return bl;
        }
        if (lhsValue instanceof Number && rhsValue instanceof Number) {
            Constable constable;
            boolean isInteger;
            boolean bl = isInteger = !(lhsValue instanceof Float) && !(lhsValue instanceof Double) && !(rhsValue instanceof Float) && !(rhsValue instanceof Double);
            boolean isWide = isInteger ? lhsValue instanceof Long || rhsValue instanceof Long : lhsValue instanceof Double || rhsValue instanceof Double;
            switch (ConstantEvaluator$WhenMappings.$EnumSwitchMapping$2[opcode.ordinal()]) {
                case 1: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() + ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() + ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() + ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() + ((Number)rhsValue).floatValue());
                    break;
                }
                case 2: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() - ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() - ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() - ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() - ((Number)rhsValue).floatValue());
                    break;
                }
                case 3: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() * ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() * ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() * ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() * ((Number)rhsValue).floatValue());
                    break;
                }
                case 4: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() / ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() / ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() / ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() / ((Number)rhsValue).floatValue());
                    break;
                }
                case 5: {
                    if (isInteger) {
                        if (isWide) {
                            constable = ((Number)lhsValue).longValue() % ((Number)rhsValue).longValue();
                            break;
                        }
                        constable = ((Number)lhsValue).intValue() % ((Number)rhsValue).intValue();
                        break;
                    }
                    if (isWide) {
                        constable = ((Number)lhsValue).doubleValue() % ((Number)rhsValue).doubleValue();
                        break;
                    }
                    constable = Float.valueOf(((Number)lhsValue).floatValue() % ((Number)rhsValue).floatValue());
                    break;
                }
                case 6: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() >> ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() >> ((Number)rhsValue).intValue();
                    break;
                }
                case 7: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() << ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() << ((Number)rhsValue).intValue();
                    break;
                }
                case 8: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() & ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() & ((Number)rhsValue).intValue();
                    break;
                }
                case 9: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() | ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() | ((Number)rhsValue).intValue();
                    break;
                }
                case 10: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() ^ ((Number)rhsValue).longValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() ^ ((Number)rhsValue).intValue();
                    break;
                }
                case 11: {
                    if (isWide) {
                        constable = ((Number)lhsValue).longValue() >>> ((Number)rhsValue).intValue();
                        break;
                    }
                    constable = ((Number)lhsValue).intValue() >>> ((Number)rhsValue).intValue();
                    break;
                }
                case 12: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() == ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() == ((Number)rhsValue).doubleValue());
                    break;
                }
                case 13: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() != ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() != ((Number)rhsValue).doubleValue());
                    break;
                }
                case 14: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() < ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() < ((Number)rhsValue).doubleValue());
                    break;
                }
                case 15: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() <= ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() <= ((Number)rhsValue).doubleValue());
                    break;
                }
                case 16: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() > ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() > ((Number)rhsValue).doubleValue());
                    break;
                }
                case 17: {
                    constable = Boolean.valueOf(isInteger ? ((Number)lhsValue).longValue() >= ((Number)rhsValue).longValue() : ((Number)lhsValue).doubleValue() >= ((Number)rhsValue).doubleValue());
                    break;
                }
                default: {
                    constable = null;
                }
            }
            return constable;
        }
        return null;
    }

    public ConstantEvaluator(@NotNull JavaClass containingClass, @NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkParameterIsNotNull(containingClass, "containingClass");
        Intrinsics.checkParameterIsNotNull(javac2, "javac");
        Intrinsics.checkParameterIsNotNull(compilationUnit, "compilationUnit");
        this.containingClass = containingClass;
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }
}

