/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.AbstractNode;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/EnumTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "entries", "", "psi", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getEntries", "()Ljava/util/List;", "createFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateStandardMethods", "", "generateValueOfFunction", "generateValuesFunction", "js.translator"})
public final class EnumTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final List<ClassDescriptor> entries;
    private final PsiElement psi;

    public final void generateStandardMethods() {
        this.generateValuesFunction();
        this.generateValueOfFunction();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValuesFunction() {
        void $receiver$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), DescriptorUtils.ENUM_VALUES);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "DescriptorUtils.getFunct\u2026criptorUtils.ENUM_VALUES)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        Iterable $receiver$iv = this.entries;
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ClassDescriptor classDescriptor = (ClassDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            JsNode jsNode = new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)it), null), new JsExpression[0]).source(this.psi);
            collection.add(jsNode);
        }
        List values2 = (List)destination$iv$iv;
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
        Collection collection = jsBlock.getStatements();
        Object $receiver = object = new JsReturn(new JsArrayLiteral(values2).source(this.psi));
        ((SourceInfoAwareJsNode)$receiver).setSource(this.psi);
        collection.add(object);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValueOfFunction() {
        AbstractNode $receiver;
        Object object;
        Object object2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), DescriptorUtils.ENUM_VALUE_OF);
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "DescriptorUtils.getFunct\u2026iptorUtils.ENUM_VALUE_OF)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        JsName nameParam = JsScope.declareTemporaryName("name");
        Collection collection = function2.getParameters();
        JsParameter jsParameter = new JsParameter(nameParam);
        collection.add(jsParameter);
        Iterable iterable = $receiver$iv = (Iterable)this.entries;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsReturn jsReturn;
            void entry;
            object2 = (ClassDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            object = new JsCase();
            $receiver = object;
            $receiver.setCaseExpression(new JsStringLiteral(entry.getName().asString()).source(this.psi));
            Collection collection3 = $receiver.getStatements();
            JsReturn $receiver2 = jsReturn = new JsReturn((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)entry), null), new JsExpression[0]).source(this.psi));
            $receiver2.setSource(this.psi);
            collection3.add(jsReturn);
            $receiver.setSource(this.psi);
            JsCase jsCase = object;
            collection2.add(jsCase);
        }
        List clauses = (List)destination$iv$iv;
        JsBinaryOperation message = new JsBinaryOperation(JsBinaryOperator.ADD, new JsStringLiteral("No enum constant " + DescriptorUtilsKt.getFqNameSafe(this.descriptor) + '.'), nameParam.makeRef());
        JsExpression throwFunction = this.context().getReferenceToIntrinsic("throwISE");
        JsExpressionStatement throwStatement = new JsExpressionStatement((JsExpression)new JsInvocation(throwFunction, message).source(this.psi));
        Object object3 = clauses;
        if (!object3.isEmpty()) {
            Object object4 = new JsDefault();
            JsDefault $receiver3 = object4;
            object = $receiver3.getStatements();
            $receiver = throwStatement;
            object.add($receiver);
            $receiver3.setSource(this.psi);
            JsDefault defaultCase = object4;
            JsBlock jsBlock = function2.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
            object4 = jsBlock.getStatements();
            Object $receiver4 = object2 = new JsSwitch(nameParam.makeRef().source(this.psi), CollectionsKt.plus((Collection)clauses, defaultCase));
            ((SourceInfoAwareJsNode)$receiver4).setSource(this.psi);
            object4.add(object2);
        } else {
            JsBlock jsBlock = function2.getBody();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
            object3 = jsBlock.getStatements();
            object3.add(throwStatement);
        }
    }

    private final JsFunction createFunction(FunctionDescriptor functionDescriptor) {
        JsFunction function2;
        JsFunction jsFunction = function2 = this.context().getFunctionObject(functionDescriptor);
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "function");
        jsFunction.setName(this.context().getInnerNameForDescriptor(functionDescriptor));
        function2.setSource(this.psi);
        this.context().addDeclarationStatement(function2.makeStmt());
        JsExpression classRef = this.context().getInnerReference(this.descriptor);
        JsNameRef functionRef = function2.getName().makeRef();
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(this.context().getNameForDescriptor(functionDescriptor), classRef), functionRef);
        this.context().addDeclarationStatement(assignment.makeStmt());
        return function2;
    }

    @NotNull
    public final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final List<ClassDescriptor> getEntries() {
        return this.entries;
    }

    public EnumTranslator(@NotNull TranslationContext context, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends ClassDescriptor> entries2, @NotNull PsiElement psi) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(entries2, "entries");
        Intrinsics.checkParameterIsNotNull(psi, "psi");
        super(context);
        this.descriptor = descriptor2;
        this.entries = entries2;
        this.psi = psi;
    }
}

