/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002-.B!\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007BM\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0015\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b,R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "", "classesByQName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassIdToJavaClass;", "(Lkotlin/jvm/functions/Function1;)V", "typeParameters", "", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "innerClasses", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "(Lkotlin/jvm/functions/Function1;Ljava/util/Map;Ljava/util/Map;)V", "addInnerClass", "", "innerInternalName", "outerInternalName", "simpleName", "addInnerClass$frontend_java", "addTypeParameters", "newTypeParameters", "", "addTypeParameters$frontend_java", "copyForMember", "copyForMember$frontend_java", "createClassIdForTopLevel", "internalName", "mapDescToClassId", "desc", "mapDescToClassId$frontend_java", "mapInternalNameToClassId", "mapInternalNameToClassId$frontend_java", "mapInternalNameToClassIdNaively", "resolveByInternalName", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "c", "resolveByInternalName$frontend_java", "resolveClass", "classId", "resolveClass$frontend_java", "resolveTypeParameter", "name", "resolveTypeParameter$frontend_java", "InnerClassInfo", "Result", "frontend.java"})
public final class ClassifierResolutionContext {
    private final Function1<ClassId, JavaClass> classesByQName;
    private Map<String, JavaTypeParameter> typeParameters;
    private Map<String, InnerClassInfo> innerClasses;

    public final void addInnerClass$frontend_java(@NotNull String innerInternalName, @NotNull String outerInternalName, @NotNull String simpleName2) {
        Intrinsics.checkParameterIsNotNull(innerInternalName, "innerInternalName");
        Intrinsics.checkParameterIsNotNull(outerInternalName, "outerInternalName");
        Intrinsics.checkParameterIsNotNull(simpleName2, "simpleName");
        if (this.innerClasses == null) {
            this.innerClasses = new THashMap();
        }
        Map<String, InnerClassInfo> map2 = this.innerClasses;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        map2.put(innerInternalName, new InnerClassInfo(outerInternalName, simpleName2));
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeParameters$frontend_java(@NotNull Collection<? extends JavaTypeParameter> newTypeParameters) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(newTypeParameters, "newTypeParameters");
        if (newTypeParameters.isEmpty()) {
            return;
        }
        if (this.typeParameters == null) {
            this.typeParameters = new THashMap();
        }
        Iterable iterable = newTypeParameters;
        Map<String, JavaTypeParameter> map2 = this.typeParameters;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        Map<String, JavaTypeParameter> destination$iv = map2;
        for (Object element$iv : $receiver$iv) {
            String string;
            void it;
            JavaTypeParameter javaTypeParameter = (JavaTypeParameter)element$iv;
            Map<String, JavaTypeParameter> map3 = destination$iv;
            Intrinsics.checkExpressionValueIsNotNull(it.getName().getIdentifier(), "it.name.identifier");
            map3.put(string, (JavaTypeParameter)element$iv);
        }
    }

    @NotNull
    public final Result resolveClass$frontend_java(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        JavaClassifier javaClassifier = this.classesByQName.invoke(classId);
        String string = classId.asSingleFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classId.asSingleFqName().asString()");
        return new Result(javaClassifier, string);
    }

    @NotNull
    public final Result resolveTypeParameter$frontend_java(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Map<String, JavaTypeParameter> map2 = this.typeParameters;
        return new Result(map2 != null ? map2.get(name) : null, name);
    }

    @NotNull
    public final ClassifierResolutionContext copyForMember$frontend_java() {
        THashMap<String, JavaTypeParameter> tHashMap;
        Map<String, JavaTypeParameter> map2;
        Map<String, JavaTypeParameter> map3;
        Map<String, JavaTypeParameter> p1;
        Function1<ClassId, JavaClass> function1;
        Map<String, Object> map4;
        Function1<ClassId, JavaClass> function12 = this.classesByQName;
        Map<String, JavaTypeParameter> map5 = this.typeParameters;
        if (map5 != null) {
            map4 = map5;
            function1 = function12;
            p1 = map4;
            map3 = new THashMap<String, JavaTypeParameter>(p1);
            function12 = function1;
            map2 = map3;
        } else {
            map2 = null;
        }
        Map<String, JavaTypeParameter> map6 = map2;
        Map<String, InnerClassInfo> map7 = this.innerClasses;
        if (map7 != null) {
            map4 = map7;
            map3 = map6;
            function1 = function12;
            p1 = map4;
            THashMap<String, JavaTypeParameter> tHashMap2 = new THashMap<String, JavaTypeParameter>(p1);
            function12 = function1;
            map6 = map3;
            tHashMap = tHashMap2;
        } else {
            tHashMap = null;
        }
        Map map8 = tHashMap;
        Map map9 = map6;
        Function1<ClassId, JavaClass> function13 = function12;
        return new ClassifierResolutionContext(function13, map9, map8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassId mapInternalNameToClassId$frontend_java(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        if (StringsKt.contains$default((CharSequence)internalName, '.', false, 2, null)) {
            List parts = StringsKt.split$default((CharSequence)internalName, new char[]{'.'}, false, 0, 6, null);
            ClassId outerClass2 = this.mapInternalNameToClassId$frontend_java((String)parts.get(0));
            List nestedParts = parts.subList(1, parts.size());
            Iterable $receiver$iv = nestedParts;
            ClassId accumulator$iv = outerClass2;
            for (Object element$iv : $receiver$iv) {
                void part;
                String string = (String)element$iv;
                ClassId classId = accumulator$iv;
                Intrinsics.checkExpressionValueIsNotNull(classId.createNestedClassId(Name.identifier((String)part)), "classId.createNestedClassId(Name.identifier(part))");
            }
            return accumulator$iv;
        }
        if (StringsKt.contains$default((CharSequence)internalName, '$', false, 2, null)) {
            Map<String, InnerClassInfo> map2 = this.innerClasses;
            if (map2 == null || (map2 = map2.get(internalName)) == null) {
                return this.mapInternalNameToClassIdNaively(internalName);
            }
            Map<String, InnerClassInfo> innerClassInfo = map2;
            if (Name.isValidIdentifier(((InnerClassInfo)((Object)innerClassInfo)).getSimpleName())) {
                ClassId outerClassId = this.mapInternalNameToClassId$frontend_java(((InnerClassInfo)((Object)innerClassInfo)).getOuterInternalName());
                ClassId classId = outerClassId.createNestedClassId(Name.identifier(((InnerClassInfo)((Object)innerClassInfo)).getSimpleName()));
                Intrinsics.checkExpressionValueIsNotNull(classId, "outerClassId.createNeste\u2026nerClassInfo.simpleName))");
                return classId;
            }
        }
        ClassId classId = this.createClassIdForTopLevel(internalName);
        Intrinsics.checkExpressionValueIsNotNull(classId, "createClassIdForTopLevel(internalName)");
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassId mapInternalNameToClassIdNaively(String internalName) {
        List splitPoints = ContainerUtil.newSmartList();
        int n = 0;
        int n2 = internalName.length() - 1;
        if (n <= n2) {
            while (true) {
                void p;
                char c;
                if ((c = internalName.charAt((int)p)) == '$' && p > 0 && internalName.charAt((int)(p - true)) != '/' && p < internalName.length() - 1 && internalName.charAt((int)(p + true)) != '$') {
                    splitPoints.add((int)p);
                }
                if (p == n2) break;
                ++p;
            }
        }
        List list2 = splitPoints;
        Intrinsics.checkExpressionValueIsNotNull(list2, "splitPoints");
        Collection p = list2;
        if (!p.isEmpty()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable c = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(Integer.valueOf(-1)), (Iterable)splitPoints), (Iterable)CollectionsKt.plus((Collection)splitPoints, Integer.valueOf(internalName.length())));
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string;
                void $from_to;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                Integer from = (Integer)$from_to.component1();
                Integer to = (Integer)$from_to.component2();
                String string2 = internalName;
                int n3 = from + 1;
                Integer n4 = to;
                Intrinsics.checkExpressionValueIsNotNull(n4, "to");
                int n5 = n4;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull(string3.substring(n3, n5), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                collection.add(string);
            }
            List substrings = (List)destination$iv$iv;
            FqName outerFqName = new FqName(StringsKt.replace$default((String)substrings.get(0), '/', '.', false, 4, null));
            FqName packageFqName = outerFqName.parent();
            FqName relativeName = new FqName(outerFqName.shortName().asString() + "." + CollectionsKt.joinToString$default(substrings.subList(1, substrings.size()), ".", null, null, 0, null, null, 62, null));
            return new ClassId(packageFqName, relativeName, false);
        }
        ClassId classId = this.createClassIdForTopLevel(internalName);
        Intrinsics.checkExpressionValueIsNotNull(classId, "createClassIdForTopLevel(internalName)");
        return classId;
    }

    private final ClassId createClassIdForTopLevel(String internalName) {
        return ClassId.topLevel(new FqName(StringsKt.replace$default(internalName, '/', '.', false, 4, null)));
    }

    @NotNull
    public final Result resolveByInternalName$frontend_java(@NotNull String c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        return this.resolveClass$frontend_java(this.mapInternalNameToClassId$frontend_java(c));
    }

    @NotNull
    public final ClassId mapDescToClassId$frontend_java(@NotNull String desc) {
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        Type type2 = Type.getType(desc);
        Intrinsics.checkExpressionValueIsNotNull(type2, "Type.getType(desc)");
        String string = type2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "Type.getType(desc).internalName");
        return this.mapInternalNameToClassId$frontend_java(string);
    }

    private ClassifierResolutionContext(Function1<? super ClassId, ? extends JavaClass> classesByQName, Map<String, JavaTypeParameter> typeParameters2, Map<String, InnerClassInfo> innerClasses2) {
        this.classesByQName = classesByQName;
        this.typeParameters = typeParameters2;
        this.innerClasses = innerClasses2;
    }

    public ClassifierResolutionContext(@NotNull Function1<? super ClassId, ? extends JavaClass> classesByQName) {
        Intrinsics.checkParameterIsNotNull(classesByQName, "classesByQName");
        this(classesByQName, null, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "", "classifier", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "qualifiedName", "", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;Ljava/lang/String;)V", "getClassifier", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "getQualifiedName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Result {
        @Nullable
        private final JavaClassifier classifier;
        @NotNull
        private final String qualifiedName;

        @Nullable
        public final JavaClassifier getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        public Result(@Nullable JavaClassifier classifier2, @NotNull String qualifiedName2) {
            Intrinsics.checkParameterIsNotNull(qualifiedName2, "qualifiedName");
            this.classifier = classifier2;
            this.qualifiedName = qualifiedName2;
        }

        @Nullable
        public final JavaClassifier component1() {
            return this.classifier;
        }

        @NotNull
        public final String component2() {
            return this.qualifiedName;
        }

        @NotNull
        public final Result copy(@Nullable JavaClassifier classifier2, @NotNull String qualifiedName2) {
            Intrinsics.checkParameterIsNotNull(qualifiedName2, "qualifiedName");
            return new Result(classifier2, qualifiedName2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Result copy$default(Result result2, JavaClassifier javaClassifier, String string, int n, Object object) {
            if ((n & 1) != 0) {
                javaClassifier = result2.classifier;
            }
            if ((n & 2) != 0) {
                string = result2.qualifiedName;
            }
            return result2.copy(javaClassifier, string);
        }

        public String toString() {
            return "Result(classifier=" + this.classifier + ", qualifiedName=" + this.qualifiedName + ")";
        }

        public int hashCode() {
            JavaClassifier javaClassifier = this.classifier;
            String string = this.qualifiedName;
            return (javaClassifier != null ? javaClassifier.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual(this.classifier, result2.classifier) || !Intrinsics.areEqual(this.qualifiedName, result2.qualifiedName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "", "outerInternalName", "", "simpleName", "(Ljava/lang/String;Ljava/lang/String;)V", "getOuterInternalName", "()Ljava/lang/String;", "getSimpleName", "frontend.java"})
    private static final class InnerClassInfo {
        @NotNull
        private final String outerInternalName;
        @NotNull
        private final String simpleName;

        @NotNull
        public final String getOuterInternalName() {
            return this.outerInternalName;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }

        public InnerClassInfo(@NotNull String outerInternalName, @NotNull String simpleName2) {
            Intrinsics.checkParameterIsNotNull(outerInternalName, "outerInternalName");
            Intrinsics.checkParameterIsNotNull(simpleName2, "simpleName");
            this.outerInternalName = outerInternalName;
            this.simpleName = simpleName2;
        }
    }
}

