/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtArrayAccessExpression
extends KtExpressionImpl
implements KtReferenceExpression {
    public KtArrayAccessExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitArrayAccessExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getArrayExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @NotNull
    public List<KtExpression> getIndexExpressions() {
        return PsiTreeUtil.getChildrenOfTypeAsList(this.getIndicesNode(), KtExpression.class);
    }

    @NotNull
    public KtContainerNode getIndicesNode() {
        KtContainerNode indicesNode = (KtContainerNode)this.findChildByType(KtNodeTypes.INDICES);
        assert (indicesNode != null) : "Can't be null because of parser";
        return indicesNode;
    }

    @NotNull
    public List<TextRange> getBracketRanges() {
        PsiElement lBracket = this.getLeftBracket();
        PsiElement rBracket = this.getRightBracket();
        if (lBracket == null || rBracket == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(lBracket.getTextRange(), rBracket.getTextRange());
    }

    @Nullable
    public PsiElement getLeftBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.LBRACKET);
    }

    @Nullable
    public PsiElement getRightBracket() {
        return this.getIndicesNode().findChildByType(KtTokens.RBRACKET);
    }
}

