/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupportKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinEnum;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Function1<KotlinType, Boolean> VALID_SUPERTYPE = type2 -> {
        assert (!KotlinTypeKt.isError(type2)) : "Error types must be filtered out in DescriptorResolver";
        return TypeUtils.getClassDescriptor(type2) != null;
    };
    private final LazyClassContext c;
    @Nullable
    private final KtClassOrObject classOrObject;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final NotNullLazyValue<Modality> modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final boolean isData;
    private final boolean isInline;
    private final boolean isExpect;
    private final boolean isActual;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<ClassDescriptorWithResolutionScopes> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<KtObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final MemberScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;
    private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
    private final NotNullLazyValue<LexicalScope> scopeForInitializerResolution;
    private final NotNullLazyValue<Collection<ClassDescriptor>> sealedSubclasses;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull KtClassLikeInfo classLikeInfo, boolean isExternal) {
        super(c.getStorageManager(), containingDeclaration, name, KotlinSourceElementKt.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()), isExternal);
        this.c = c;
        this.classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (this.classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, this.classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        StorageManager storageManager = c.getStorageManager();
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.kind = classLikeInfo.getClassKind();
        this.staticScope = this.kind == ClassKind.ENUM_CLASS ? new StaticScopeForKotlinEnum(storageManager, this) : MemberScope.Empty.INSTANCE;
        this.typeConstructor = new LazyClassTypeConstructor();
        this.isCompanionObject = classLikeInfo instanceof KtObjectInfo && ((KtObjectInfo)classLikeInfo).isCompanionObject();
        KtModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = storageManager.createLazyValue(() -> Modality.FINAL);
        } else {
            Modality defaultModality = this.kind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = storageManager.createLazyValue(() -> ModifiersChecker.resolveModalityFromModifiers(this.classOrObject, defaultModality, c.getTrace().getBindingContext(), null, true));
        }
        boolean isLocal = this.classOrObject != null && KtPsiUtil.isLocal(this.classOrObject);
        Visibility defaultVisibility = this.kind == ClassKind.ENUM_ENTRY || this.kind == ClassKind.OBJECT && this.isCompanionObject ? Visibilities.PUBLIC : Visibilities.DEFAULT_VISIBILITY;
        this.visibility = isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
        this.isInner = modifierList != null && modifierList.hasModifier(KtTokens.INNER_KEYWORD) && !LazyClassDescriptor.isIllegalInner(this);
        this.isData = modifierList != null && modifierList.hasModifier(KtTokens.DATA_KEYWORD);
        this.isInline = modifierList != null && modifierList.hasModifier(KtTokens.INLINE_KEYWORD);
        this.isActual = modifierList != null && PsiUtilsKt.hasActualModifier(modifierList);
        this.isExpect = modifierList != null && PsiUtilsKt.hasExpectModifier(modifierList) || containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).isExpect();
        ArrayList<KtAnnotationEntry> annotationEntries = new ArrayList<KtAnnotationEntry>();
        if (this.classOrObject != null && this.classOrObject.getParent() instanceof KtObjectLiteralExpression) {
            annotationEntries.addAll(KtPsiUtilKt.getAnnotationEntries((KtObjectLiteralExpression)this.classOrObject.getParent()));
        }
        if (modifierList != null) {
            annotationEntries.addAll(modifierList.getAnnotationEntries());
        }
        this.annotations = !annotationEntries.isEmpty() ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                return LazyClassDescriptor.this.getOuterScope();
            }
        }, annotationEntries) : Annotations.Companion.getEMPTY();
        List<KtAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.Companion.getEMPTY() : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                return LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
            }
        }, jetDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(() -> this.computeCompanionObjectDescriptor(this.getCompanionObjectIfAllowed()));
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(this::computeCompanionObjectDescriptor);
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(() -> {
            this.doForceResolveAllContents();
            return null;
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, this::getOuterScope);
        this.parameters = c.getStorageManager().createLazyValue(() -> {
            List<KtTypeParameter> typeParameters2;
            KtClassLikeInfo classInfo = this.declarationProvider.getOwnerInfo();
            KtTypeParameterList typeParameterList = classInfo.getTypeParameterList();
            if (typeParameterList == null) {
                return Collections.emptyList();
            }
            if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
            }
            if (classInfo.getClassKind() == ClassKind.OBJECT) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_OBJECT.on(typeParameterList));
            }
            if ((typeParameters2 = typeParameterList.getParameters()).isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<LazyTypeParameterDescriptor> parameters2 = new ArrayList<LazyTypeParameterDescriptor>(typeParameters2.size());
            for (int i = 0; i < typeParameters2.size(); ++i) {
                parameters2.add(new LazyTypeParameterDescriptor(c, this, typeParameters2.get(i), i));
            }
            return parameters2;
        });
        this.scopeForInitializerResolution = storageManager.createLazyValue(() -> ClassResolutionScopesSupportKt.scopeForInitializerResolution(this, this.createInitializerScopeParent(), classLikeInfo.getPrimaryConstructorParameters()));
        this.sealedSubclasses = storageManager.createLazyValue(() -> DescriptorUtilsKt.computeSealedSubclasses(this));
    }

    private static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor2) {
        if (!DescriptorUtils.isClass(descriptor2)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        return !(containingDeclaration instanceof ClassDescriptor) || DescriptorUtils.isInterface(containingDeclaration) || DescriptorUtils.isObject(containingDeclaration);
    }

    @NotNull
    private DeclarationDescriptor createInitializerScopeParent() {
        ClassConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            return primaryConstructor2;
        }
        return new FunctionDescriptorImpl(this, null, Annotations.Companion.getEMPTY(), Name.special("<init-blocks>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE){
            {
                this.initialize(null, null, Collections.emptyList(), Collections.emptyList(), null, Modality.FINAL, Visibilities.PRIVATE);
            }

            @Override
            @NotNull
            protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        return new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        return this.unsubstitutedMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        return this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        return this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
    }

    @Override
    @NotNull
    public LexicalScope getScopeForConstructorHeaderResolution() {
        return this.resolutionScopesSupport.getScopeForConstructorHeaderResolution().invoke();
    }

    @Override
    @NotNull
    public LexicalScope getScopeForCompanionObjectHeaderResolution() {
        return this.resolutionScopesSupport.getScopeForCompanionObjectHeaderResolution().invoke();
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        return this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        return this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        return (LexicalScope)this.scopeForInitializerResolution.invoke();
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        return CollectionsKt.filter(DescriptorUtils.getAllDescriptors(this.unsubstitutedMemberScope), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        return this.unsubstitutedMemberScope.getConstructors();
    }

    @Override
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    public ClassDescriptorWithResolutionScopes getCompanionObjectDescriptor() {
        return (ClassDescriptorWithResolutionScopes)this.companionObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        KtObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        return CollectionsKt.map(CollectionsKt.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), companionObject -> companionObject != allowedCompanionObject), this.extraCompanionObjectDescriptors);
    }

    @Nullable
    private ClassDescriptorWithResolutionScopes computeCompanionObjectDescriptor(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject == null) {
            return this.createSyntheticCompanionObjectDescriptor();
        }
        KtClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject);
        if (!(companionObjectInfo instanceof KtClassOrObjectInfo)) {
            return null;
        }
        Name name = ((KtClassOrObjectInfo)companionObjectInfo).getName();
        assert (name != null);
        this.getUnsubstitutedMemberScope().getContributedClassifier(name, NoLookupLocation.WHEN_GET_COMPANION_OBJECT);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject);
        if (companionObjectDescriptor2 instanceof ClassDescriptorWithResolutionScopes) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (ClassDescriptorWithResolutionScopes)companionObjectDescriptor2;
        }
        return null;
    }

    private ClassDescriptorWithResolutionScopes createSyntheticCompanionObjectDescriptor() {
        Name syntheticCompanionName = this.c.getSyntheticResolveExtension().getSyntheticCompanionObjectNameIfNeeded(this);
        if (syntheticCompanionName == null) {
            return null;
        }
        return new SyntheticClassOrObjectDescriptor(this.c, this.classOrObject, this, syntheticCompanionName, this.getSource(), this.getOuterScope(), Modality.FINAL, Visibilities.PUBLIC, Visibilities.PRIVATE, ClassKind.OBJECT, true);
    }

    @Nullable
    private static KtClassLikeInfo getCompanionObjectInfo(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject != null) {
            return KtClassInfoUtil.createClassLikeInfo(companionObject);
        }
        return null;
    }

    @Nullable
    private KtObjectDeclaration getCompanionObjectIfAllowed() {
        KtObjectDeclaration companionObject = CollectionsKt.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject != null && this.isCompanionObjectAllowed() ? companionObject : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return (Modality)((Object)this.modality.invoke());
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return this.isData;
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    public boolean isExpect() {
        return this.isExpect;
    }

    @Override
    public boolean isActual() {
        return this.isActual;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        return this.danglingAnnotations;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        return (Collection)this.sealedSubclasses.invoke();
    }

    public String toString() {
        return (this.isExpect ? "expect " : (this.isActual ? "actual " : "")) + "class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        ClassDescriptorWithResolutionScopes companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope());
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        return (List)this.parameters.invoke();
    }

    @NotNull
    protected Collection<KotlinType> computeSupertypes() {
        if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(this)) {
            return Collections.emptyList();
        }
        KtClassOrObject classOrObject = this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
        if (classOrObject == null) {
            return Collections.singleton(this.c.getModuleDescriptor().getBuiltIns().getAnyType());
        }
        List<KotlinType> allSupertypes2 = this.c.getDescriptorResolver().resolveSupertypes(this.getScopeForClassHeaderResolution(), this, classOrObject, this.c.getTrace());
        return new ArrayList<KotlinType>(CollectionsKt.filter(allSupertypes2, VALID_SUPERTYPE));
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor {
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;

        public LazyClassTypeConstructor() {
            super(LazyClassDescriptor.this.c.getStorageManager());
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(() -> TypeParameterUtilsKt.computeConstructorTypeParameters(LazyClassDescriptor.this));
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            return LazyClassDescriptor.this.computeSupertypes();
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            ClassifierDescriptor supertypeDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (supertypeDescriptor instanceof ClassDescriptor) {
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        @Override
        protected void reportScopesLoopError(@NotNull KotlinType type2) {
            PsiElement reportOn = DescriptorToSourceUtils.getSourceFromDescriptor(type2.getConstructor().getDeclarationDescriptor());
            if (reportOn instanceof KtClass) {
                reportOn = ((KtClass)reportOn).getNameIdentifier();
            }
            if (reportOn != null) {
                LazyClassDescriptor.this.c.getTrace().report(Errors.CYCLIC_SCOPES_WITH_COMPANION.on(reportOn));
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)psiElement;
                for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
                    KotlinType supertype;
                    KtTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            return LazyClassDescriptor.this.c.getSupertypeLoopChecker();
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return (List)this.parameters.invoke();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }
    }
}

