/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnresolvedType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.utils.Printer;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptor(){

        @Override
        @Nullable
        public <T> T getCapability(@NotNull ModuleDescriptor.Capability<T> capability) {
            return null;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            return Annotations.Companion.getEMPTY();
        }

        @Override
        @NotNull
        public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public Name getName() {
            return Name.special("<ERROR MODULE>");
        }

        @Override
        @NotNull
        public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
            throw new IllegalStateException("Should not be called!");
        }

        @Override
        @NotNull
        public List<ModuleDescriptor> getAllDependencyModules() {
            return CollectionsKt.emptyList();
        }

        @Override
        @Nullable
        public ModuleDescriptor getExpectedByModule() {
            return null;
        }

        @Override
        public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
            return null;
        }

        @Override
        public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        }

        @Override
        public boolean shouldSeeInternalsOf(@NotNull ModuleDescriptor targetModule) {
            return false;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getOriginal() {
            return this;
        }

        @Override
        @Nullable
        public DeclarationDescriptor getContainingDeclaration() {
            return null;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DefaultBuiltIns.getInstance();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void assertValid() {
            throw new InvalidModuleException("ERROR_MODULE is not a valid module");
        }
    };
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor(Name.special("<ERROR CLASS>"));
    public static final SimpleType ERROR_TYPE_FOR_LOOP_IN_SUPERTYPES = ErrorUtils.createErrorType("<LOOP IN SUPERTYPES>");
    private static final KotlinType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final PropertyDescriptor ERROR_PROPERTY = ErrorUtils.createErrorProperty();
    private static final Set<PropertyDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor instanceof FunctionDescriptor) {
            return ErrorUtils.containsErrorType((FunctionDescriptor)callableDescriptor);
        }
        return ErrorUtils.containsErrorType(callableDescriptor.getReturnType());
    }

    public static boolean containsErrorType(@NotNull FunctionDescriptor function2) {
        if (ErrorUtils.containsErrorType(function2.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function2.getExtensionReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function2.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function2.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ClassDescriptor createErrorClass(@NotNull String debugMessage) {
        return new ErrorClassDescriptor(Name.special("<ERROR CLASS: " + debugMessage + ">"));
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage) {
        return ErrorUtils.createErrorScope(debugMessage, false);
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (throwExceptions) {
            return new ThrowingScope(debugMessage);
        }
        return new ErrorScope(debugMessage);
    }

    @NotNull
    private static PropertyDescriptorImpl createErrorProperty() {
        PropertyDescriptorImpl descriptor2 = PropertyDescriptorImpl.create(ERROR_CLASS, Annotations.Companion.getEMPTY(), Modality.OPEN, Visibilities.PUBLIC, true, Name.special("<ERROR PROPERTY>"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE, false, false, false, false, false, false);
        descriptor2.setType(ERROR_PROPERTY_TYPE, Collections.emptyList(), null, (KotlinType)null);
        return descriptor2;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        ErrorSimpleFunctionDescriptorImpl function2 = new ErrorSimpleFunctionDescriptorImpl(ERROR_CLASS, ownerScope);
        function2.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.PUBLIC);
        return function2;
    }

    @NotNull
    public static SimpleType createErrorType(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeWithArguments(debugMessage, Collections.<TypeProjection>emptyList());
    }

    @NotNull
    public static SimpleType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        return ErrorUtils.createErrorTypeWithCustomConstructor(debugName, ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName));
    }

    @NotNull
    public static SimpleType createErrorTypeWithCustomConstructor(@NotNull String debugName, @NotNull TypeConstructor typeConstructor2) {
        return new ErrorType(typeConstructor2, ErrorUtils.createErrorScope(debugName));
    }

    @NotNull
    public static SimpleType createErrorTypeWithArguments(@NotNull String debugMessage, @NotNull List<TypeProjection> arguments2) {
        return new ErrorType(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage), arguments2, false);
    }

    @NotNull
    public static SimpleType createUnresolvedType(@NotNull String presentableName2, @NotNull List<TypeProjection> arguments2) {
        return new UnresolvedType(presentableName2, ErrorUtils.createErrorTypeConstructor(presentableName2), ErrorUtils.createErrorScope(presentableName2), arguments2, false);
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        return ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]", ERROR_CLASS);
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        return ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName, ERROR_CLASS);
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(final @NotNull String debugName, final @NotNull ErrorClassDescriptor errorClass) {
        return new TypeConstructor(){

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                return CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            public Collection<KotlinType> getSupertypes() {
                return CollectionsKt.emptyList();
            }

            @Override
            public boolean isFinal() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return false;
            }

            @Override
            @Nullable
            public ClassifierDescriptor getDeclarationDescriptor() {
                return errorClass;
            }

            @Override
            @NotNull
            public KotlinBuiltIns getBuiltIns() {
                return DefaultBuiltIns.getInstance();
            }

            public String toString() {
                return debugName;
            }
        };
    }

    public static boolean containsErrorType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        if (KotlinTypeKt.isError(type2)) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@Nullable DeclarationDescriptor candidate2) {
        if (candidate2 == null) {
            return false;
        }
        return ErrorUtils.isErrorClass(candidate2) || ErrorUtils.isErrorClass(candidate2.getContainingDeclaration()) || candidate2 == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate2) {
        return candidate2 instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        return ERROR_MODULE;
    }

    public static boolean isUninferredParameter(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() instanceof UninferredParameterTypeConstructor;
    }

    public static boolean containsUninferredParameter(@Nullable KotlinType type2) {
        return TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(){

            @Override
            public Boolean invoke(UnwrappedType argumentType) {
                return ErrorUtils.isUninferredParameter(argumentType);
            }
        });
    }

    @NotNull
    public static KotlinType createUninferredParameterType(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        return ErrorUtils.createErrorTypeWithCustomConstructor("Scope for error type for not inferred parameter: " + typeParameterDescriptor.getName(), new UninferredParameterTypeConstructor(typeParameterDescriptor));
    }

    private ErrorUtils() {
    }

    public static class UninferredParameterTypeConstructor
    implements TypeConstructor {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final TypeConstructor errorTypeConstructor;

        private UninferredParameterTypeConstructor(@NotNull TypeParameterDescriptor descriptor2) {
            this.typeParameterDescriptor = descriptor2;
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("CANT_INFER_TYPE_PARAMETER: " + descriptor2.getName());
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            return this.typeParameterDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.errorTypeConstructor.getParameters();
        }

        @Override
        @NotNull
        public Collection<KotlinType> getSupertypes() {
            return this.errorTypeConstructor.getSupertypes();
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DescriptorUtilsKt.getBuiltIns(this.typeParameterDescriptor);
        }
    }

    private static class ErrorClassDescriptor
    extends ClassDescriptorImpl {
        public ErrorClassDescriptor(@NotNull Name name) {
            super(ErrorUtils.getErrorModule(), name, Modality.OPEN, ClassKind.CLASS, Collections.<KotlinType>emptyList(), SourceElement.NO_SOURCE, false);
            ClassConstructorDescriptorImpl errorConstructor = ClassConstructorDescriptorImpl.create(this, Annotations.Companion.getEMPTY(), true, SourceElement.NO_SOURCE);
            errorConstructor.initialize(Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
            MemberScope memberScope2 = ErrorUtils.createErrorScope(this.getName().asString());
            errorConstructor.setReturnType(new ErrorType(ErrorUtils.createErrorTypeConstructorWithCustomDebugName("<ERROR>", this), memberScope2));
            this.initialize(memberScope2, Collections.singleton(errorConstructor), errorConstructor);
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
            return this;
        }

        @Override
        public String toString() {
            return this.getName().asString();
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments2) {
            return ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments2);
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
            return ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeSubstitution);
        }
    }

    private static class ThrowingScope
    implements MemberScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location2) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @NotNull
        public Collection getContributedVariables(@NotNull Name name, @NotNull LookupLocation location2) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @NotNull
        public Collection getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location2) {
            throw new IllegalStateException(this.debugMessage + ", required name: " + name);
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            throw new IllegalStateException(this.debugMessage);
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            throw new IllegalStateException();
        }

        @Override
        public Set<Name> getClassifierNames() {
            throw new IllegalStateException();
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location2) {
            throw new IllegalStateException();
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            return false;
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements MemberScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            this.debugMessage = debugMessage;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location2) {
            return ErrorUtils.createErrorClass(name.asString());
        }

        @NotNull
        public Set getContributedVariables(@NotNull Name name, @NotNull LookupLocation location2) {
            return ERROR_PROPERTY_GROUP;
        }

        @NotNull
        public Set getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location2) {
            return Collections.singleton(ErrorUtils.createErrorFunction(this));
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Name> getClassifierNames() {
            return Collections.emptySet();
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location2) {
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            return Collections.emptyList();
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            return false;
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

