/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u000b\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u0017\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"constructors", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getConstructors", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Ljava/util/Collection;", "kind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "getKind", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Lorg/jetbrains/kotlin/descriptors/ClassKind;", "descriptorsEqualWithSubstitution", "", "descriptor1", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor2", "checkOriginals", "findCallableMemberBySignature", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "signature", "allowOverridabilityConflicts", "supertypesWithAny", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "ide-common"})
public final class DescriptorUtilsKt {
    public static final boolean descriptorsEqualWithSubstitution(@Nullable DeclarationDescriptor descriptor1, @Nullable DeclarationDescriptor descriptor2, boolean checkOriginals) {
        KotlinTypeChecker typeChecker2;
        if (Intrinsics.areEqual(descriptor1, descriptor2)) {
            return true;
        }
        if (descriptor1 == null || descriptor2 == null) {
            return false;
        }
        if (checkOriginals && Intrinsics.areEqual(descriptor1.getOriginal(), descriptor2.getOriginal()) ^ true) {
            return false;
        }
        if (!(descriptor1 instanceof CallableDescriptor)) {
            return true;
        }
        CallableDescriptor cfr_ignored_0 = (CallableDescriptor)descriptor2;
        KotlinTypeChecker kotlinTypeChecker = typeChecker2 = KotlinTypeCheckerImpl.withAxioms(new KotlinTypeChecker.TypeConstructorEquality(descriptor1, descriptor2){
            final /* synthetic */ DeclarationDescriptor $descriptor1;
            final /* synthetic */ DeclarationDescriptor $descriptor2;

            public boolean equals(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                Intrinsics.checkParameterIsNotNull(a, "a");
                Intrinsics.checkParameterIsNotNull(b, "b");
                ClassifierDescriptor classifierDescriptor = a.getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                    classifierDescriptor = null;
                }
                TypeParameterDescriptor typeParam1 = (TypeParameterDescriptor)classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2 = b.getDeclarationDescriptor();
                if (!(classifierDescriptor2 instanceof TypeParameterDescriptor)) {
                    classifierDescriptor2 = null;
                }
                TypeParameterDescriptor typeParam2 = (TypeParameterDescriptor)classifierDescriptor2;
                if (typeParam1 != null && typeParam2 != null && Intrinsics.areEqual(typeParam1.getContainingDeclaration(), this.$descriptor1) && Intrinsics.areEqual(typeParam2.getContainingDeclaration(), this.$descriptor2)) {
                    return typeParam1.getIndex() == typeParam2.getIndex();
                }
                return Intrinsics.areEqual(a, b);
            }
            {
                this.$descriptor1 = $captured_local_variable$0;
                this.$descriptor2 = $captured_local_variable$1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeChecker, "typeChecker");
        if (!TypeUtilsKt.equalTypesOrNulls(kotlinTypeChecker, ((CallableDescriptor)descriptor1).getReturnType(), ((CallableDescriptor)descriptor2).getReturnType())) {
            return false;
        }
        List<ValueParameterDescriptor> parameters1 = ((CallableDescriptor)descriptor1).getValueParameters();
        List<ValueParameterDescriptor> parameters2 = ((CallableDescriptor)descriptor2).getValueParameters();
        if (parameters1.size() != parameters2.size()) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = parameters1;
        Intrinsics.checkExpressionValueIsNotNull(list2, "parameters1");
        Iterable iterable = list2;
        List<ValueParameterDescriptor> list3 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list3, "parameters2");
        for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list3)) {
            ValueParameterDescriptor param1 = (ValueParameterDescriptor)pair.component1();
            ValueParameterDescriptor param2 = (ValueParameterDescriptor)pair.component2();
            ValueParameterDescriptor valueParameterDescriptor = param1;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "param1");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            ValueParameterDescriptor valueParameterDescriptor2 = param2;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "param2");
            if (typeChecker2.equalTypes(kotlinType, valueParameterDescriptor2.getType())) continue;
            return false;
        }
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean descriptorsEqualWithSubstitution$default(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return DescriptorUtilsKt.descriptorsEqualWithSubstitution(declarationDescriptor, declarationDescriptor2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CallableMemberDescriptor findCallableMemberBySignature(@NotNull ClassDescriptor $receiver, @NotNull CallableMemberDescriptor signature2, boolean allowOverridabilityConflicts) {
        Object v3;
        block5: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(signature2, "signature");
            DescriptorKindFilter descriptorKind = signature2 instanceof FunctionDescriptor ? DescriptorKindFilter.FUNCTIONS : DescriptorKindFilter.VARIABLES;
            Iterable iterable = ResolutionScope.DefaultImpls.getContributedDescriptors$default($receiver.getDefaultType().getMemberScope(), descriptorKind, null, 2, null);
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (Intrinsics.areEqual(it.getContainingDeclaration(), $receiver) ^ true) {
                    bl = false;
                } else {
                    CallableMemberDescriptor callableMemberDescriptor = it;
                    if (callableMemberDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                    }
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, signature2, null);
                    Intrinsics.checkExpressionValueIsNotNull(overrideCompatibilityInfo, "OverridingUtil.DEFAULT.i\u2026criptor, signature, null)");
                    OverridingUtil.OverrideCompatibilityInfo.Result overridability = overrideCompatibilityInfo.getResult();
                    bl = overridability == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || allowOverridabilityConflicts && overridability == OverridingUtil.OverrideCompatibilityInfo.Result.CONFLICT;
                }
                if (!bl) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        return v3;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CallableMemberDescriptor findCallableMemberBySignature$default(ClassDescriptor classDescriptor, CallableMemberDescriptor callableMemberDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.findCallableMemberBySignature(classDescriptor, callableMemberDescriptor, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinType> supertypesWithAny(@NotNull TypeConstructor $receiver) {
        Collection collection;
        boolean noSuperClass;
        Collection supertypes2;
        block7: {
            boolean bl;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Collection collection2 = supertypes2 = $receiver.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection2, "supertypes");
            Iterable $receiver$iv = collection2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                collection3.add(classDescriptor);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    if (it == null || it.getKind() == ClassKind.INTERFACE) continue;
                    bl = false;
                    break block7;
                }
                bl = noSuperClass = true;
            }
        }
        if (noSuperClass) {
            KotlinBuiltIns kotlinBuiltIns = $receiver.getBuiltIns();
            Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "builtIns");
            collection = CollectionsKt.plus(supertypes2, kotlinBuiltIns.getAnyType());
        } else {
            collection = supertypes2;
        }
        return collection;
    }

    @NotNull
    public static final Collection<ConstructorDescriptor> getConstructors(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        Collection<ClassConstructorDescriptor> collection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = $receiver;
        if (classifierDescriptorWithTypeParameters instanceof TypeAliasDescriptor) {
            collection = ((TypeAliasDescriptor)$receiver).getConstructors();
        } else if (classifierDescriptorWithTypeParameters instanceof ClassDescriptor) {
            Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)$receiver).getConstructors();
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "this.constructors");
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public static final ClassKind getKind(@NotNull ClassifierDescriptorWithTypeParameters $receiver) {
        ClassKind classKind;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = $receiver;
        if (classifierDescriptorWithTypeParameters instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)$receiver).getClassDescriptor();
            classKind = classDescriptor != null ? classDescriptor.getKind() : null;
        } else {
            classKind = classifierDescriptorWithTypeParameters instanceof ClassDescriptor ? ((ClassDescriptor)$receiver).getKind() : null;
        }
        return classKind;
    }
}

