/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.gradle.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.utilities.DokkaLogger;
import org.jetbrains.dokka.utilities.LoggingLevel;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0016R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/dokka/gradle/internal/LoggerAdapter;", "Lorg/jetbrains/dokka/utilities/DokkaLogger;", "Ljava/lang/AutoCloseable;", "outputFile", "Ljava/io/File;", "logger", "Lorg/slf4j/Logger;", "logTag", "", "(Ljava/io/File;Lorg/slf4j/Logger;Ljava/lang/String;)V", "value", "", "errorsCount", "getErrorsCount", "()I", "setErrorsCount", "(I)V", "errorsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "logWriter", "Ljava/io/Writer;", "warningsCount", "getWarningsCount", "setWarningsCount", "warningsCounter", "close", "", "debug", "message", "error", "info", "log", "level", "Lorg/jetbrains/dokka/utilities/LoggingLevel;", "progress", "warn", "dokka-gradle-plugin"})
public final class LoggerAdapter
implements DokkaLogger,
AutoCloseable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String logTag;
    @NotNull
    private final Writer logWriter;
    @NotNull
    private final AtomicInteger warningsCounter;
    @NotNull
    private final AtomicInteger errorsCounter;

    public LoggerAdapter(@NotNull File outputFile, @NotNull Logger logger, @NotNull String logTag) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        this.logger = logger;
        this.logTag = logTag;
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        File file = outputFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file;
        this.logWriter = (object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        this.warningsCounter = new AtomicInteger();
        this.errorsCounter = new AtomicInteger();
    }

    public int getWarningsCount() {
        return this.warningsCounter.get();
    }

    public void setWarningsCount(int value) {
        this.warningsCounter.set(value);
    }

    public int getErrorsCount() {
        return this.errorsCounter.get();
    }

    public void setErrorsCount(int value) {
        this.errorsCounter.set(value);
    }

    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.DEBUG, message);
    }

    public void progress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.PROGRESS, message);
    }

    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log(LoggingLevel.INFO, message);
    }

    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int n = this.getWarningsCount();
        this.setWarningsCount(n + 1);
        this.log(LoggingLevel.WARN, message);
    }

    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int n = this.getErrorsCount();
        this.setErrorsCount(n + 1);
        this.log(LoggingLevel.ERROR, message);
    }

    private final synchronized void log(LoggingLevel level, String message) {
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: 
            case 2: {
                this.logger.info('[' + this.logTag + "] " + ((Object)StringsKt.trimStart((CharSequence)StringsKt.prependIndent$default((String)message, null, (int)1, null))).toString());
                break;
            }
            case 3: {
                this.logger.debug('[' + this.logTag + "] " + ((Object)StringsKt.trimStart((CharSequence)StringsKt.prependIndent$default((String)message, null, (int)1, null))).toString());
                break;
            }
            case 4: {
                this.logger.warn("w: [" + this.logTag + "] " + ((Object)StringsKt.trimStart((CharSequence)StringsKt.prependIndent$default((String)message, null, (int)1, null))).toString());
                break;
            }
            case 5: {
                this.logger.error("e: [" + this.logTag + "] " + ((Object)StringsKt.trimStart((CharSequence)StringsKt.prependIndent$default((String)message, null, (int)1, null))).toString());
            }
        }
        Appendable appendable = ((Appendable)this.logWriter).append('[' + level.name() + "] " + message);
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
    }

    @Override
    public void close() {
        this.logWriter.close();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingLevel.values().length];
            try {
                nArray[LoggingLevel.PROGRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

