/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.gradle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.JsonObject;
import org.gradle.api.Action;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.gradle.DokkaBasePlugin;
import org.jetbrains.dokka.gradle.engine.parameters.DokkaModuleDescriptionKxs;
import org.jetbrains.dokka.gradle.engine.parameters.DokkaSourceSetSpec;
import org.jetbrains.dokka.gradle.engine.plugins.DokkaPluginParametersBaseSpec;
import org.jetbrains.dokka.gradle.internal.InternalDokkaGradlePluginApi;
import org.jetbrains.dokka.gradle.tasks.DokkaGenerateTask;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/dokka/gradle/tasks/DokkaGenerateModuleTask;", "Lorg/jetbrains/dokka/gradle/tasks/DokkaGenerateTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "workers", "Lorg/gradle/workers/WorkerExecutor;", "archives", "Lorg/gradle/api/file/ArchiveOperations;", "fs", "Lorg/gradle/api/file/FileSystemOperations;", "pluginsConfiguration", "Lorg/gradle/api/ExtensiblePolymorphicDomainObjectContainer;", "Lorg/jetbrains/dokka/gradle/engine/plugins/DokkaPluginParametersBaseSpec;", "Lorg/jetbrains/dokka/gradle/internal/DokkaPluginParametersContainer;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/api/file/FileSystemOperations;Lorg/gradle/api/ExtensiblePolymorphicDomainObjectContainer;)V", "modulePath", "Lorg/gradle/api/provider/Property;", "", "getModulePath", "()Lorg/gradle/api/provider/Property;", "generateModule", "", "generateModule$dokka_gradle_plugin", "generateModuleConfiguration", "Lorg/jetbrains/dokka/gradle/engine/parameters/DokkaModuleDescriptionKxs;", "moduleDescriptorJson", "Ljava/io/File;", "dokka-gradle-plugin"})
public abstract class DokkaGenerateModuleTask
extends DokkaGenerateTask {
    @NotNull
    private final FileSystemOperations fs;

    @Inject
    @InternalDokkaGradlePluginApi
    public DokkaGenerateModuleTask(@NotNull ObjectFactory objects, @NotNull WorkerExecutor workers, @NotNull ArchiveOperations archives, @NotNull FileSystemOperations fs, @NotNull ExtensiblePolymorphicDomainObjectContainer<DokkaPluginParametersBaseSpec> pluginsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)workers, (String)"workers");
        Intrinsics.checkNotNullParameter((Object)archives, (String)"archives");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter(pluginsConfiguration, (String)"pluginsConfiguration");
        super(objects, archives, workers, pluginsConfiguration);
        this.fs = fs;
    }

    @Input
    @NotNull
    public abstract Property<String> getModulePath();

    @TaskAction
    public final void generateModule$dokka_gradle_plugin() {
        File file = ((Directory)this.getOutputDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
        File outputDirectory = file;
        File moduleDescriptorJson = FilesKt.resolve((File)outputDirectory, (String)"module-descriptor.json");
        this.fs.delete(new Action(outputDirectory){
            final /* synthetic */ File $outputDirectory;
            {
                this.$outputDirectory = $outputDirectory;
            }

            public final void execute(DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
                Object[] objectArray = new Object[]{this.$outputDirectory};
                $this$delete.delete(objectArray);
            }
        });
        outputDirectory.mkdirs();
        DokkaModuleDescriptionKxs moduleDescriptor = this.generateModuleConfiguration(moduleDescriptorJson);
        File includesOutputDir = FilesKt.resolve((File)outputDirectory, (String)moduleDescriptor.getModuleIncludesDirName());
        File moduleOutputDir = FilesKt.resolve((File)outputDirectory, (String)moduleDescriptor.getModuleOutputDirName());
        this.generateDocumentation(DokkaGenerateTask.GeneratorMode.Module, moduleOutputDir);
        this.fs.sync(new Action(includesOutputDir, this){
            final /* synthetic */ File $includesOutputDir;
            final /* synthetic */ DokkaGenerateModuleTask this$0;
            {
                this.$includesOutputDir = $includesOutputDir;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(SyncSpec $this$sync) {
                Collection<ConfigurableFileCollection> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$sync, (String)"$this$sync");
                $this$sync.into((Object)this.$includesOutputDir);
                Object[] objectArray = new Object[]{this.this$0.getGenerator().getIncludes()};
                $this$sync.from(objectArray);
                objectArray = new Object[1];
                Iterable iterable = (Iterable)this.this$0.getGenerator().getDokkaSourceSets();
                int n = 0;
                Object[] objectArray2 = objectArray;
                SyncSpec syncSpec = $this$sync;
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DokkaSourceSetSpec dokkaSourceSetSpec = (DokkaSourceSetSpec)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIncludes());
                }
                collection = (List)destination$iv$iv;
                objectArray2[n] = collection;
                syncSpec.from(objectArray);
            }
        });
    }

    private final DokkaModuleDescriptionKxs generateModuleConfiguration(File moduleDescriptorJson) {
        File file;
        Object object = this.getGenerator().getModuleName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generator.moduleName.get()");
        String moduleName = (String)object;
        Object object2 = this.getModulePath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"modulePath.get()");
        String modulePath = (String)object2;
        DokkaModuleDescriptionKxs moduleDesc = new DokkaModuleDescriptionKxs(moduleName, modulePath, null, null, 12, null);
        String encodedModuleDesc = DokkaBasePlugin.Companion.getJsonMapper$dokka_gradle_plugin().encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)DokkaModuleDescriptionKxs.Companion.toJsonObject(moduleDesc));
        this.getLogger().info(CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)("encodedModuleDesc: " + encodedModuleDesc)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        File $this$generateModuleConfiguration_u24lambda_u240 = file = moduleDescriptorJson;
        boolean bl = false;
        $this$generateModuleConfiguration_u24lambda_u240.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$generateModuleConfiguration_u24lambda_u240, (String)encodedModuleDesc, null, (int)2, null);
        return moduleDesc;
    }
}

