/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.AbstractQuery;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Key;
import org.jetbrains.exposed.v1.core.TableKt;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.dao.id.IdTable;
import org.jetbrains.exposed.v1.core.statements.BatchUpdateStatement;
import org.jetbrains.exposed.v1.core.statements.BatchUpsertStatement;
import org.jetbrains.exposed.v1.core.statements.DeleteStatement;
import org.jetbrains.exposed.v1.core.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.ReturningStatement;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.StatementContext;
import org.jetbrains.exposed.v1.core.statements.StatementGroup;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.core.statements.UpsertStatement;
import org.jetbrains.exposed.v1.core.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.v1.dao.Entity;
import org.jetbrains.exposed.v1.dao.EntityCache;
import org.jetbrains.exposed.v1.dao.EntityCacheKt;
import org.jetbrains.exposed.v1.dao.EntityHookKt;
import org.jetbrains.exposed.v1.dao.EntityLifecycleInterceptorKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0018\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0002J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0018\u001a\u00020\n*\u00020\f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/v1/dao/EntityLifecycleInterceptor;", "Lorg/jetbrains/exposed/v1/core/statements/GlobalStatementInterceptor;", "<init>", "()V", "keepUserDataInTransactionStoreOnCommit", "", "Lorg/jetbrains/exposed/v1/core/Key;", "", "userData", "beforeExecution", "", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "context", "Lorg/jetbrains/exposed/v1/core/statements/StatementContext;", "childStatement", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "afterExecution", "contexts", "", "executedStatement", "Lorg/jetbrains/exposed/v1/core/statements/api/PreparedStatementApi;", "beforeCommit", "beforeRollback", "flushEntities", "query", "Lorg/jetbrains/exposed/v1/core/AbstractQuery;", "exposed-dao"})
@SourceDebugExtension(value={"SMAP\nEntityLifecycleInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityLifecycleInterceptor.kt\norg/jetbrains/exposed/v1/dao/EntityLifecycleInterceptor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n503#2,7:118\n808#3,11:125\n1863#3,2:136\n808#3,11:138\n1863#3,2:149\n808#3,11:151\n1863#3,2:162\n*S KotlinDebug\n*F\n+ 1 EntityLifecycleInterceptor.kt\norg/jetbrains/exposed/v1/dao/EntityLifecycleInterceptor\n*L\n31#1:118,7\n51#1:125,11\n51#1:136,2\n61#1:138,11\n61#1:149,2\n79#1:151,11\n79#1:162,2\n*E\n"})
public final class EntityLifecycleInterceptor
implements GlobalStatementInterceptor {
    @NotNull
    public Map<Key<?>, Object> keepUserDataInTransactionStoreOnCommit(@NotNull Map<Key<?>, ? extends Object> userData) {
        Intrinsics.checkNotNullParameter(userData, (String)"userData");
        Map<Key<?>, Object> $this$filterValues$iv = userData;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry<Key<?>, Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it instanceof EntityCache)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    public void beforeExecution(@NotNull Transaction transaction, @NotNull StatementContext context) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.beforeExecution(transaction, context, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void beforeExecution(Transaction transaction, StatementContext context, Statement<?> childStatement) {
        Statement statement;
        Statement statement2 = childStatement;
        if (statement2 == null) {
            statement2 = context.getStatement();
        }
        if ((statement = statement2) instanceof AbstractQuery) {
            this.flushEntities(transaction, (AbstractQuery)statement);
        } else if (statement instanceof ReturningStatement) {
            this.beforeExecution(transaction, context, ((ReturningStatement)statement).getMainStatement());
        } else if (statement instanceof DeleteStatement) {
            EntityCacheKt.flushCache(transaction);
            EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(TableKt.targetTables((ColumnSet)((DeleteStatement)statement).getTargetsSet()), false);
            if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                void $this$forEach$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((DeleteStatement)statement).getTargets();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof IdTable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdTable it = (IdTable)element$iv;
                    boolean bl = false;
                    Map<Object, Entity<?>> map = EntityCacheKt.getEntityCache(transaction).getData().get(it);
                    if (map != null) {
                        map.clear();
                    }
                }
            }
        } else if (statement instanceof UpsertStatement || statement instanceof BatchUpsertStatement) {
            EntityCacheKt.flushCache(transaction);
            EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(((InsertStatement)statement).getTargets(), true);
            if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                void $this$forEach$iv;
                Iterable $this$filterIsInstance$iv = ((InsertStatement)statement).getTargets();
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IdTable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdTable it = (IdTable)element$iv;
                    boolean bl2 = false;
                    Map<Object, Entity<?>> map = EntityCacheKt.getEntityCache(transaction).getData().get(it);
                    if (map != null) {
                        map.clear();
                    }
                }
            }
        } else if (statement instanceof InsertStatement) {
            EntityCacheKt.flushCache(transaction);
            EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(CollectionsKt.listOf((Object)((InsertStatement)statement).getTable()), true);
        } else if (!(statement instanceof BatchUpdateStatement)) {
            if (statement instanceof UpdateStatement) {
                EntityCacheKt.flushCache(transaction);
                EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(TableKt.targetTables((ColumnSet)((UpdateStatement)statement).getTargetsSet()), false);
                if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                    void $this$forEach$iv;
                    Iterable $this$filterIsInstance$iv = ((UpdateStatement)statement).getTargets();
                    boolean $i$f$filterIsInstance = false;
                    Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IdTable)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IdTable it = (IdTable)element$iv;
                        boolean bl = false;
                        Map<Object, Entity<?>> map = EntityCacheKt.getEntityCache(transaction).getData().get(it);
                        if (map != null) {
                            map.clear();
                        }
                    }
                }
            } else if (statement.getType().getGroup() == StatementGroup.DDL) {
                EntityCacheKt.flushCache(transaction);
            }
        }
    }

    public void afterExecution(@NotNull Transaction transaction, @NotNull List<StatementContext> contexts, @NotNull PreparedStatementApi executedStatement) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter((Object)executedStatement, (String)"executedStatement");
        if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle() || !(((StatementContext)CollectionsKt.first(contexts)).getStatement() instanceof InsertStatement)) {
            EntityHookKt.alertSubscribers(transaction);
        }
    }

    public void beforeCommit(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        List<Entity<?>> created = EntityCacheKt.flushCache(transaction);
        EntityHookKt.alertSubscribers(transaction);
        List<Entity<?>> createdByHooks = EntityCacheKt.flushCache(transaction);
        EntityCache.Companion.invalidateGlobalCaches(CollectionsKt.plus((Collection)created, (Iterable)createdByHooks));
    }

    public void beforeRollback(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        EntityCache entityCache = EntityCacheKt.getEntityCache(transaction);
        entityCache.clearReferrersCache();
        entityCache.getData().clear();
        entityCache.getInserts$exposed_dao().clear();
    }

    private final void flushEntities(Transaction $this$flushEntities, AbstractQuery<?> query) {
        Set tables = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)query.getTargets(), IdTable.class));
        EntityCacheKt.getEntityCache($this$flushEntities).flush(tables);
    }

    public void afterStatementPrepared(@NotNull Transaction transaction, @NotNull PreparedStatementApi preparedStatement) {
        GlobalStatementInterceptor.DefaultImpls.afterStatementPrepared((GlobalStatementInterceptor)this, (Transaction)transaction, (PreparedStatementApi)preparedStatement);
    }

    public void afterCommit(@NotNull Transaction transaction) {
        GlobalStatementInterceptor.DefaultImpls.afterCommit((GlobalStatementInterceptor)this, (Transaction)transaction);
    }

    public void afterRollback(@NotNull Transaction transaction) {
        GlobalStatementInterceptor.DefaultImpls.afterRollback((GlobalStatementInterceptor)this, (Transaction)transaction);
    }
}

