/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.money;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.VarCharColumnType;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/v1/money/CurrencyColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Ljavax/money/CurrencyUnit;", "<init>", "()V", "sqlType", "", "validateValueBeforeUpdate", "", "value", "valueFromDB", "", "notNullValueToDB", "nonNullValueToString", "equals", "", "other", "hashCode", "", "escape", "Companion", "exposed-money"})
@SourceDebugExtension(value={"SMAP\nCurrencyColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrencyColumnType.kt\norg/jetbrains/exposed/v1/money/CurrencyColumnType\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,77:1\n975#2:78\n1046#2,3:79\n*S KotlinDebug\n*F\n+ 1 CurrencyColumnType.kt\norg/jetbrains/exposed/v1/money/CurrencyColumnType\n*L\n62#1:78\n62#1:79,3\n*E\n"})
public final class CurrencyColumnType
extends ColumnType<CurrencyUnit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int COLUMN_LENGTH = 3;
    @NotNull
    private static final Map<Character, String> charactersToEscape;

    public CurrencyColumnType() {
        super(false, 1, null);
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().varcharType(3);
    }

    public void validateValueBeforeUpdate(@Nullable CurrencyUnit value) {
        if (value != null) {
            String string = value.getCurrencyCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
            String string2 = string;
            int n = 0;
            int n2 = value.getCurrencyCode().length();
            int valueLength = string2.codePointCount(n, n2);
            if (!(valueLength <= 3)) {
                boolean bl = false;
                String string3 = "Value can't be stored to database column because exceeds length (" + valueLength + " > 3)";
                throw new IllegalArgumentException(string3.toString());
            }
        }
    }

    @NotNull
    public CurrencyUnit valueFromDB(@NotNull Object value) {
        CurrencyUnit currencyUnit;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof CurrencyUnit) {
            currencyUnit = (CurrencyUnit)value;
        } else if (object instanceof String) {
            CurrencyUnit currencyUnit2 = Monetary.getCurrency((String)((String)value), (String[])new String[0]);
            currencyUnit = currencyUnit2;
            Intrinsics.checkNotNullExpressionValue((Object)currencyUnit2, (String)"getCurrency(...)");
        } else {
            currencyUnit = this.valueFromDB(value.toString());
        }
        return currencyUnit;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull CurrencyUnit value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
        return string;
    }

    @NotNull
    public String nonNullValueToString(@NotNull CurrencyUnit value) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringBuilder $this$nonNullValueToString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$nonNullValueToString_u24lambda_u241.append('\'');
        String string = value.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
        $this$nonNullValueToString_u24lambda_u241.append(this.escape(string));
        $this$nonNullValueToString_u24lambda_u241.append('\'');
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.VarCharColumnType");
        VarCharColumnType cfr_ignored_0 = (VarCharColumnType)other;
        return 3 == ((VarCharColumnType)other).getColLength();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + 3;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String value) {
        void $this$mapTo$iv$iv;
        CharSequence $this$map$iv = value;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = charactersToEscape.get(Character.valueOf((char)it));
            if (object == null) {
                object = Character.valueOf((char)it);
            }
            collection.add(object);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\''), (Object)"''"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"\\r"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"\\n")};
        charactersToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/v1/money/CurrencyColumnType$Companion;", "", "<init>", "()V", "COLUMN_LENGTH", "", "charactersToEscape", "", "", "", "exposed-money"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

