/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;
import thirdparty.kotlin.Metadata;
import thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import thirdparty.kotlin.jvm.internal.Intrinsics;
import thirdparty.kotlin.jvm.internal.markers.KMappedMarker;
import thirdparty.kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/digest/ChunkIterator;", "", "Ljava/nio/ByteBuffer;", "dataSource", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "maximumChunkSize", "", "(Lorg/jetbrains/zip/signer/datasource/DataSource;I)V", "chunkCount", "getChunkCount", "()I", "index", "inputSize", "", "chunkSize", "hasNext", "", "next", "lib"})
public final class ChunkIterator
implements Iterator<ByteBuffer>,
KMappedMarker {
    @NotNull
    private final DataSource dataSource;
    private final int maximumChunkSize;
    private final int chunkCount;
    private int index;

    public ChunkIterator(@NotNull DataSource dataSource, int maximumChunkSize) {
        Intrinsics.checkNotNullParameter(dataSource, "dataSource");
        this.dataSource = dataSource;
        this.maximumChunkSize = maximumChunkSize;
        this.chunkCount = this.getChunkCount(this.dataSource.size(), this.maximumChunkSize);
    }

    public /* synthetic */ ChunkIterator(DataSource dataSource, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0x100000;
        }
        this(dataSource, n);
    }

    public final int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.chunkCount;
    }

    @Override
    @NotNull
    public ByteBuffer next() {
        if (this.index < 0 || this.index >= this.chunkCount) {
            throw new NoSuchElementException();
        }
        int chunkSize = (int)RangesKt.coerceAtMost(this.dataSource.size() - (long)(this.index * this.maximumChunkSize), (long)this.maximumChunkSize);
        ByteBuffer chunk = this.dataSource.getByteBuffer((long)this.index * (long)this.maximumChunkSize, chunkSize);
        ++this.index;
        return chunk;
    }

    private final int getChunkCount(long inputSize, int chunkSize) {
        long chunkCountLong = (inputSize + (long)chunkSize - 1L) / (long)chunkSize;
        if (!(this.chunkCount < Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "Number of chunks in dataSource is greater than max int.";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)chunkCountLong;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

