/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.signer.SignerInfo;
import thirdparty.kotlin.Metadata;
import thirdparty.kotlin.collections.CollectionsKt;
import thirdparty.kotlin.jvm.functions.Function1;
import thirdparty.kotlin.jvm.internal.Intrinsics;
import thirdparty.kotlin.jvm.internal.SourceDebugExtension;
import thirdparty.kotlin.sequences.Sequence;
import thirdparty.kotlin.sequences.SequencesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"getSignerInfo", "Lorg/jetbrains/zip/signer/signer/SignerInfo;", "Ljava/security/KeyStore;", "keyPassword", "", "alias", "", "getSingleKeyEntryAlias", "lib"})
@SourceDebugExtension(value={"SMAP\nKeystoreUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeystoreUtils.kt\norg/jetbrains/zip/signer/signer/KeystoreUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,43:1\n1#2:44\n11065#3:45\n11400#3,3:46\n1313#4,2:49\n*S KotlinDebug\n*F\n+ 1 KeystoreUtils.kt\norg/jetbrains/zip/signer/signer/KeystoreUtilsKt\n*L\n23#1:45\n23#1:46,3\n33#1:49,2\n*E\n"})
public final class KeystoreUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerInfo getSignerInfo(@NotNull KeyStore $this$getSignerInfo, @NotNull char[] keyPassword, @Nullable String alias) {
        void $this$mapTo$iv$iv;
        String definedKeyAlias;
        Intrinsics.checkNotNullParameter($this$getSignerInfo, "<this>");
        Intrinsics.checkNotNullParameter(keyPassword, "keyPassword");
        String string = alias;
        if (string == null) {
            string = KeystoreUtilsKt.getSingleKeyEntryAlias($this$getSignerInfo);
        }
        if (!$this$getSignerInfo.isKeyEntry(definedKeyAlias = string)) {
            boolean $i$a$-require-KeystoreUtilsKt$getSignerInfo$32 = false;
            String $i$a$-require-KeystoreUtilsKt$getSignerInfo$32 = "Keystore entry '" + definedKeyAlias + "' does not contain a key";
            throw new IllegalArgumentException($i$a$-require-KeystoreUtilsKt$getSignerInfo$32.toString());
        }
        Key key = $this$getSignerInfo.getKey(definedKeyAlias, keyPassword);
        Intrinsics.checkNotNull(key, "null cannot be cast to non-null type java.security.PrivateKey");
        PrivateKey key2 = (PrivateKey)key;
        Certificate[] certificateArray = $this$getSignerInfo.getCertificateChain(definedKeyAlias);
        Intrinsics.checkNotNullExpressionValue(certificateArray, "getCertificateChain(...)");
        Object[] $this$map$iv = certificateArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)it);
        }
        List certificateChain = (List)destination$iv$iv;
        if (!(!((Collection)certificateChain).isEmpty())) {
            boolean bl = false;
            String string2 = "Keystore '" + definedKeyAlias + "' does not contain certificates";
            throw new IllegalArgumentException(string2.toString());
        }
        return new SignerInfo(certificateChain, key2);
    }

    private static final String getSingleKeyEntryAlias(KeyStore $this$getSingleKeyEntryAlias) {
        String definedKeyAlias = null;
        Enumeration<String> enumeration = $this$getSingleKeyEntryAlias.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, "aliases(...)");
        Sequence<String> $this$forEach$iv = SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), (Function1)new Function1<String, Boolean>($this$getSingleKeyEntryAlias){
            final /* synthetic */ KeyStore $this_getSingleKeyEntryAlias;
            {
                this.$this_getSingleKeyEntryAlias = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.$this_getSingleKeyEntryAlias.isKeyEntry(it);
            }
        });
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl = false;
            if (definedKeyAlias != null) {
                throw new IllegalArgumentException("Keystore contains multiple key entries. --ks-key-alias option must be used to specify which entry to use.");
            }
            definedKeyAlias = it;
        }
        return definedKeyAlias;
    }
}

