/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thirdparty.bouncycastle.asn1.ASN1ObjectIdentifier;
import thirdparty.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import thirdparty.bouncycastle.openssl.PEMDecryptorProvider;
import thirdparty.bouncycastle.openssl.PEMEncryptedKeyPair;
import thirdparty.bouncycastle.openssl.PEMKeyPair;
import thirdparty.bouncycastle.openssl.PEMParser;
import thirdparty.bouncycastle.openssl.PasswordException;
import thirdparty.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import thirdparty.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import thirdparty.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import thirdparty.bouncycastle.operator.InputDecryptorProvider;
import thirdparty.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import thirdparty.kotlin.Metadata;
import thirdparty.kotlin.io.FilesKt;
import thirdparty.kotlin.jvm.JvmStatic;
import thirdparty.kotlin.jvm.internal.Intrinsics;
import thirdparty.kotlin.text.Charsets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/signer/PrivateKeyUtils;", "", "()V", "extractKeyFromPemObject", "Lthirdparty/bouncycastle/openssl/PEMKeyPair;", "pemObject", "password", "", "loadKeyPair", "file", "Ljava/io/File;", "reader", "Ljava/io/Reader;", "key", "", "loadPrivateKey", "Ljava/security/PrivateKey;", "encodedPrivateKey", "lib"})
public final class PrivateKeyUtils {
    @NotNull
    public static final PrivateKeyUtils INSTANCE = new PrivateKeyUtils();

    private PrivateKeyUtils() {
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey loadPrivateKey(@NotNull File file, @Nullable char[] password) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        return PrivateKeyUtils.loadPrivateKey(FilesKt.readText$default(file, null, 1, null), password);
    }

    @JvmStatic
    @NotNull
    public static final PrivateKey loadPrivateKey(@NotNull String encodedPrivateKey, @Nullable char[] password) throws IOException {
        Intrinsics.checkNotNullParameter(encodedPrivateKey, "encodedPrivateKey");
        PEMKeyPair keyPair = INSTANCE.loadKeyPair(new StringReader(encodedPrivateKey), password);
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(keyPair.getPrivateKeyInfo());
        Intrinsics.checkNotNullExpressionValue(privateKey, "getPrivateKey(...)");
        return privateKey;
    }

    @NotNull
    public final PEMKeyPair loadKeyPair(@NotNull String key, @Nullable char[] password) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.loadKeyPair(new StringReader(key), password);
    }

    @NotNull
    public final PEMKeyPair loadKeyPair(@NotNull File file, @Nullable char[] password) {
        Intrinsics.checkNotNullParameter(file, "file");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return this.loadKeyPair(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n), password);
    }

    private final PEMKeyPair loadKeyPair(Reader reader, char[] password) {
        PEMParser parser = new PEMParser(reader);
        Object pemObject = parser.readObject();
        if (pemObject instanceof ASN1ObjectIdentifier) {
            pemObject = parser.readObject();
        }
        Object object = pemObject;
        Intrinsics.checkNotNull(object);
        return this.extractKeyFromPemObject(object, password);
    }

    private final PEMKeyPair extractKeyFromPemObject(Object pemObject, char[] password) {
        PEMKeyPair pEMKeyPair;
        Object object = pemObject;
        if (object instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw new PasswordException("Can't read private key. Password is missing");
            }
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            PEMKeyPair pEMKeyPair2 = ((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decryptorProvider);
            Intrinsics.checkNotNull(pEMKeyPair2);
            pEMKeyPair = pEMKeyPair2;
        } else if (object instanceof PEMKeyPair) {
            pEMKeyPair = (PEMKeyPair)pemObject;
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            if (password == null) {
                throw new PasswordException("Can't read private key. Password is missing");
            }
            InputDecryptorProvider decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password);
            PrivateKeyInfo privateKey = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo(decryptorProvider);
            pEMKeyPair = new PEMKeyPair(null, privateKey);
        } else if (object instanceof PrivateKeyInfo) {
            pEMKeyPair = new PEMKeyPair(null, (PrivateKeyInfo)pemObject);
        } else {
            throw new IllegalArgumentException("Failed to parse private key");
        }
        return pEMKeyPair;
    }
}

