/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.utils.ByteBufferExtensionsKt;
import thirdparty.kotlin.Metadata;
import thirdparty.kotlin.enums.EnumEntries;
import thirdparty.kotlin.enums.EnumEntriesKt;
import thirdparty.kotlin.io.FilesKt;
import thirdparty.kotlin.jvm.internal.Intrinsics;
import thirdparty.kotlin.text.Charsets;
import thirdparty.kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/zip/signer/signer/PublicKeyUtils;", "", "()V", "veryHighStrengthKeySize", "", "getSshDsaPublicKey", "Ljava/security/PublicKey;", "buffer", "Ljava/nio/ByteBuffer;", "getSshRsaPublicKey", "getSuggestedRsaAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "key", "Ljava/security/interfaces/RSAKey;", "getSuggestedSignatureAlgorithm", "publicKey", "loadOpenSshKey", "file", "Ljava/io/File;", "SupportedPublicKeysAlgorithms", "lib"})
public final class PublicKeyUtils {
    @NotNull
    public static final PublicKeyUtils INSTANCE = new PublicKeyUtils();
    private static final int veryHighStrengthKeySize = 3072;

    private PublicKeyUtils() {
    }

    @NotNull
    public final PublicKey loadOpenSshKey(@NotNull File file) {
        PublicKey publicKey;
        String algorithmName;
        Intrinsics.checkNotNullParameter(file, "file");
        String base64Encoded = StringsKt.substringBefore$default(StringsKt.substringAfter$default(FilesKt.readText$default(file, null, 1, null), " ", null, 2, null), " ", null, 2, null);
        ByteBuffer decodedKeyByteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(base64Encoded));
        Intrinsics.checkNotNull(decodedKeyByteBuffer);
        String string = StringsKt.removePrefix(new String(ByteBufferExtensionsKt.getLengthPrefixedArray(decodedKeyByteBuffer), Charsets.UTF_8), (CharSequence)"ssh-").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        String string2 = algorithmName = string;
        if (Intrinsics.areEqual(string2, SupportedPublicKeysAlgorithms.RSA.getOpenSshName())) {
            publicKey = this.getSshRsaPublicKey(decodedKeyByteBuffer);
        } else if (Intrinsics.areEqual(string2, SupportedPublicKeysAlgorithms.DSA.getOpenSshName())) {
            publicKey = this.getSshDsaPublicKey(decodedKeyByteBuffer);
        } else {
            throw new IllegalArgumentException("Unsupported public key algorithm " + algorithmName);
        }
        return publicKey;
    }

    @NotNull
    public final SignatureAlgorithm getSuggestedSignatureAlgorithm(@NotNull PublicKey publicKey) {
        SignatureAlgorithm signatureAlgorithm;
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        PublicKey publicKey2 = publicKey;
        if (publicKey2 instanceof RSAKey) {
            signatureAlgorithm = this.getSuggestedRsaAlgorithm((RSAKey)((Object)publicKey));
        } else if (publicKey2 instanceof ECKey) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_WITH_SHA384;
        } else if (publicKey2 instanceof DSAKey) {
            signatureAlgorithm = SignatureAlgorithm.DSA_WITH_SHA256;
        } else {
            throw new InvalidKeyException("Unsupported key algorithm: " + publicKey.getAlgorithm());
        }
        return signatureAlgorithm;
    }

    private final PublicKey getSshRsaPublicKey(ByteBuffer buffer) {
        BigInteger publicExponent = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger modulus = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
        Intrinsics.checkNotNullExpressionValue(publicKey, "generatePublic(...)");
        return publicKey;
    }

    private final PublicKey getSshDsaPublicKey(ByteBuffer buffer) {
        BigInteger prime = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger subPrime = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger base = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        BigInteger publicKey = new BigInteger(ByteBufferExtensionsKt.getLengthPrefixedArray(buffer));
        PublicKey publicKey2 = KeyFactory.getInstance("DSA").generatePublic(new DSAPublicKeySpec(publicKey, prime, subPrime, base));
        Intrinsics.checkNotNullExpressionValue(publicKey2, "generatePublic(...)");
        return publicKey2;
    }

    private final SignatureAlgorithm getSuggestedRsaAlgorithm(RSAKey key) {
        return key.getModulus().bitLength() <= veryHighStrengthKeySize ? SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256 : SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/zip/signer/signer/PublicKeyUtils$SupportedPublicKeysAlgorithms;", "", "openSshName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getOpenSshName", "()Ljava/lang/String;", "RSA", "DSA", "lib"})
    private static final class SupportedPublicKeysAlgorithms
    extends Enum<SupportedPublicKeysAlgorithms> {
        @NotNull
        private final String openSshName;
        public static final /* enum */ SupportedPublicKeysAlgorithms RSA = new SupportedPublicKeysAlgorithms("RSA");
        public static final /* enum */ SupportedPublicKeysAlgorithms DSA = new SupportedPublicKeysAlgorithms("DSS");
        private static final /* synthetic */ SupportedPublicKeysAlgorithms[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SupportedPublicKeysAlgorithms(String openSshName) {
            this.openSshName = openSshName;
        }

        @NotNull
        public final String getOpenSshName() {
            return this.openSshName;
        }

        public static SupportedPublicKeysAlgorithms[] values() {
            return (SupportedPublicKeysAlgorithms[])$VALUES.clone();
        }

        public static SupportedPublicKeysAlgorithms valueOf(String value) {
            return Enum.valueOf(SupportedPublicKeysAlgorithms.class, value);
        }

        @NotNull
        public static EnumEntries<SupportedPublicKeysAlgorithms> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = supportedPublicKeysAlgorithmsArray = new SupportedPublicKeysAlgorithms[]{SupportedPublicKeysAlgorithms.RSA, SupportedPublicKeysAlgorithms.DSA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

