/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;
import thirdparty.kotlin.Metadata;
import thirdparty.kotlin.collections.CollectionsKt;
import thirdparty.kotlin.jvm.internal.Intrinsics;
import thirdparty.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0000\u00a8\u0006\u000e"}, d2={"generateSignatureOverData", "", "digest", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signatureProvider", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "signatureVerifier", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "generateSignerBlock", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certificates", "", "Ljava/security/cert/X509Certificate;", "contentDigests", "lib"})
@SourceDebugExtension(value={"SMAP\nSigning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signing.kt\norg/jetbrains/zip/signer/signing/SigningKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n*S KotlinDebug\n*F\n+ 1 Signing.kt\norg/jetbrains/zip/signer/signing/SigningKt\n*L\n19#1:47\n19#1:48,3\n*E\n"})
public final class SigningKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerBlock generateSignerBlock(@NotNull List<? extends X509Certificate> certificates, @NotNull SignatureProvider signatureProvider, @NotNull List<Digest> contentDigests) {
        Object v0;
        SignatureAlgorithm signatureAlgorithm;
        List encodedCertificates;
        block4: {
            Digest it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(certificates, "certificates");
            Intrinsics.checkNotNullParameter(signatureProvider, "signatureProvider");
            Intrinsics.checkNotNullParameter(contentDigests, "contentDigests");
            if (certificates.isEmpty()) {
                throw new SignatureException("No certificates configured for signer");
            }
            Iterable $this$map$iv = certificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Certificate)((Object)it)).getEncoded());
            }
            encodedCertificates = (List)destination$iv$iv;
            signatureAlgorithm = signatureProvider.getSignatureAlgorithm();
            Iterable iterable2 = contentDigests;
            for (Object t : iterable2) {
                it = (Digest)t;
                boolean bl = false;
                if (!(it.getAlgorithm() == signatureAlgorithm.getContentDigestAlgorithm())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Digest digest = v0;
        if (digest == null) {
            throw new RuntimeException((Object)((Object)signatureAlgorithm.getContentDigestAlgorithm()) + " content digest not computed");
        }
        Digest digest2 = digest;
        DefaultSignatureVerifier signatureVerifier = new DefaultSignatureVerifier(certificates, signatureAlgorithm);
        SignatureData signature = new SignatureData(signatureAlgorithm, SigningKt.generateSignatureOverData(digest2, signatureProvider, signatureVerifier));
        return new SignerBlock(encodedCertificates, CollectionsKt.listOf(signature));
    }

    private static final byte[] generateSignatureOverData(Digest digest, SignatureProvider signatureProvider, SignatureVerifier signatureVerifier) {
        byte[] signatureBytes = signatureProvider.sign(digest.getDigestBytes());
        signatureVerifier.verify(digest.getDigestBytes(), signatureBytes);
        return signatureBytes;
    }
}

