/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.asn1.cmc;

import java.math.BigInteger;
import thirdparty.bouncycastle.asn1.ASN1Integer;
import thirdparty.bouncycastle.asn1.ASN1Object;
import thirdparty.bouncycastle.asn1.ASN1Primitive;
import thirdparty.bouncycastle.asn1.ASN1Sequence;
import thirdparty.bouncycastle.asn1.DERSequence;
import thirdparty.bouncycastle.asn1.x509.GeneralName;

public class GetCert
extends ASN1Object {
    private final GeneralName issuerName;
    private final BigInteger serialNumber;

    private GetCert(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.issuerName = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
        this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
    }

    public GetCert(GeneralName generalName, BigInteger bigInteger) {
        this.issuerName = generalName;
        this.serialNumber = bigInteger;
    }

    public static GetCert getInstance(Object object) {
        if (object instanceof GetCert) {
            return (GetCert)object;
        }
        if (object != null) {
            return new GetCert(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public GeneralName getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.issuerName, new ASN1Integer(this.serialNumber));
    }
}

