/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cert.cmp;

import java.math.BigInteger;
import thirdparty.bouncycastle.asn1.cmp.CMPCertificate;
import thirdparty.bouncycastle.asn1.cmp.CertStatus;
import thirdparty.bouncycastle.asn1.cmp.PKIStatusInfo;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.cert.X509CertificateHolder;
import thirdparty.bouncycastle.cert.cmp.CMPException;
import thirdparty.bouncycastle.cert.cmp.CMPUtil;
import thirdparty.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import thirdparty.bouncycastle.operator.DigestCalculatorProvider;
import thirdparty.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        byte[] byArray = CMPUtil.calculateCertHash(cMPCertificate, algorithmIdentifier, digestCalculatorProvider, this.digestAlgFinder);
        return Arrays.constantTimeAreEqual(this.certStatus.getCertHash().getOctets(), byArray);
    }
}

