/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cert.crmf;

import java.io.IOException;
import thirdparty.bouncycastle.asn1.cms.EnvelopedData;
import thirdparty.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import thirdparty.bouncycastle.asn1.crmf.EncKeyWithID;
import thirdparty.bouncycastle.asn1.crmf.EncryptedKey;
import thirdparty.bouncycastle.asn1.crmf.PKIArchiveOptions;
import thirdparty.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import thirdparty.bouncycastle.asn1.x509.GeneralName;
import thirdparty.bouncycastle.cert.crmf.PKIArchiveControl;
import thirdparty.bouncycastle.cms.CMSEnvelopedData;
import thirdparty.bouncycastle.cms.CMSEnvelopedDataGenerator;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.CMSProcessableByteArray;
import thirdparty.bouncycastle.cms.RecipientInfoGenerator;
import thirdparty.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

