/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import thirdparty.bouncycastle.asn1.cmp.PBMParameter;
import thirdparty.bouncycastle.asn1.crmf.PKMACValue;
import thirdparty.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import thirdparty.bouncycastle.cert.crmf.CRMFException;
import thirdparty.bouncycastle.cert.crmf.PKMACBuilder;
import thirdparty.bouncycastle.operator.MacCalculator;
import thirdparty.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getOctets());
    }
}

