/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cert.crmf.jcajce;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import thirdparty.bouncycastle.asn1.crmf.EncryptedValue;
import thirdparty.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import thirdparty.bouncycastle.cert.crmf.CRMFException;
import thirdparty.bouncycastle.cert.crmf.EncryptedValueBuilder;
import thirdparty.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import thirdparty.bouncycastle.operator.KeyWrapper;
import thirdparty.bouncycastle.operator.OutputEncryptor;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

