/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cert.path.validations;

import thirdparty.bouncycastle.asn1.x509.Extension;
import thirdparty.bouncycastle.asn1.x509.KeyUsage;
import thirdparty.bouncycastle.cert.X509CertificateHolder;
import thirdparty.bouncycastle.cert.path.CertPathValidation;
import thirdparty.bouncycastle.cert.path.CertPathValidationContext;
import thirdparty.bouncycastle.cert.path.CertPathValidationException;
import thirdparty.bouncycastle.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean isMandatory;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean bl) {
        this.isMandatory = bl;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        certPathValidationContext.addHandledExtension(Extension.keyUsage);
        if (!certPathValidationContext.isEndEntity()) {
            KeyUsage keyUsage = KeyUsage.fromExtensions(x509CertificateHolder.getExtensions());
            if (keyUsage != null) {
                if (!keyUsage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.isMandatory) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    @Override
    public Memoable copy() {
        return new KeyUsageValidation(this.isMandatory);
    }

    @Override
    public void reset(Memoable memoable) {
        KeyUsageValidation keyUsageValidation = (KeyUsageValidation)memoable;
        this.isMandatory = keyUsageValidation.isMandatory;
    }
}

