/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms;

import thirdparty.bouncycastle.asn1.DEROctetString;
import thirdparty.bouncycastle.asn1.cms.KEKIdentifier;
import thirdparty.bouncycastle.asn1.cms.KEKRecipientInfo;
import thirdparty.bouncycastle.asn1.cms.RecipientInfo;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.RecipientInfoGenerator;
import thirdparty.bouncycastle.operator.GenericKey;
import thirdparty.bouncycastle.operator.OperatorException;
import thirdparty.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

