/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms;

import java.io.IOException;
import thirdparty.bouncycastle.asn1.cms.KEKIdentifier;
import thirdparty.bouncycastle.asn1.cms.KEKRecipientInfo;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.CMSSecureReadable;
import thirdparty.bouncycastle.cms.KEKRecipient;
import thirdparty.bouncycastle.cms.KEKRecipientId;
import thirdparty.bouncycastle.cms.Recipient;
import thirdparty.bouncycastle.cms.RecipientInformation;
import thirdparty.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

