/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms;

import thirdparty.bouncycastle.asn1.ASN1Integer;
import thirdparty.bouncycastle.asn1.DEROctetString;
import thirdparty.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import thirdparty.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import thirdparty.bouncycastle.asn1.cms.KEMRecipientInfo;
import thirdparty.bouncycastle.asn1.cms.OtherRecipientInfo;
import thirdparty.bouncycastle.asn1.cms.RecipientIdentifier;
import thirdparty.bouncycastle.asn1.cms.RecipientInfo;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.KEMKeyWrapper;
import thirdparty.bouncycastle.cms.RecipientInfoGenerator;
import thirdparty.bouncycastle.operator.GenericKey;
import thirdparty.bouncycastle.operator.OperatorException;

public abstract class KEMRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final KEMKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KEMRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, KEMKeyWrapper kEMKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = kEMKeyWrapper;
    }

    protected KEMRecipientInfoGenerator(byte[] byArray, KEMKeyWrapper kEMKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = kEMKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new OtherRecipientInfo(CMSObjectIdentifiers.id_ori_kem, new KEMRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(this.wrapper.getEncapsulation()), this.wrapper.getKdfAlgorithmIdentifier(), new ASN1Integer(this.wrapper.getKekLength()), null, this.wrapper.getWrapAlgorithmIdentifier(), new DEROctetString(byArray))));
    }
}

