/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms;

import thirdparty.bouncycastle.asn1.ASN1OctetString;
import thirdparty.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import thirdparty.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import thirdparty.bouncycastle.asn1.cms.RecipientIdentifier;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.CMSSecureReadable;
import thirdparty.bouncycastle.cms.KeyTransRecipient;
import thirdparty.bouncycastle.cms.KeyTransRecipientId;
import thirdparty.bouncycastle.cms.Recipient;
import thirdparty.bouncycastle.cms.RecipientInformation;
import thirdparty.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

