/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.cert.X509CertificateHolder;
import thirdparty.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import thirdparty.bouncycastle.cms.CMSAttributeTableGenerator;
import thirdparty.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import thirdparty.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import thirdparty.bouncycastle.cms.SignerInfoGenerator;
import thirdparty.bouncycastle.cms.SignerInfoGeneratorBuilder;
import thirdparty.bouncycastle.operator.ContentSigner;
import thirdparty.bouncycastle.operator.DigestCalculatorProvider;
import thirdparty.bouncycastle.operator.OperatorCreationException;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this(digestCalculatorProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder) {
        this.builder = new SignerInfoGeneratorBuilder(digestCalculatorProvider, cMSSignatureEncryptionAlgorithmFinder);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean bl) {
        this.builder.setDirectSignature(bl);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setContentDigest(AlgorithmIdentifier algorithmIdentifier) {
        this.builder.setContentDigest(algorithmIdentifier);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.builder.setSignedAttributeGenerator(cMSAttributeTableGenerator);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.builder.setUnsignedAttributeGenerator(cMSAttributeTableGenerator);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, x509CertificateHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] byArray) throws OperatorCreationException {
        return this.builder.build(contentSigner, byArray);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate x509Certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(x509Certificate));
    }
}

