/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import thirdparty.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.bouncycastle.cms.CMSException;
import thirdparty.bouncycastle.cms.KeyTransRecipientId;
import thirdparty.bouncycastle.cms.RecipientOperator;
import thirdparty.bouncycastle.cms.jcajce.JceKTSKeyTransRecipient;
import thirdparty.bouncycastle.jcajce.io.CipherInputStream;
import thirdparty.bouncycastle.operator.InputDecryptor;

public class JceKTSKeyTransEnvelopedRecipient
extends JceKTSKeyTransRecipient {
    public JceKTSKeyTransEnvelopedRecipient(PrivateKey privateKey, KeyTransRecipientId keyTransRecipientId) throws IOException {
        super(privateKey, JceKTSKeyTransEnvelopedRecipient.getPartyVInfoFromRID(keyTransRecipientId));
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Cipher cipher = this.contentHelper.createContentCipher(key, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, cipher);
            }
        });
    }
}

