/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.bouncycastle.crypto.digests;

import thirdparty.bouncycastle.crypto.DataLengthException;
import thirdparty.bouncycastle.crypto.OutputLengthException;
import thirdparty.bouncycastle.crypto.Xof;
import thirdparty.bouncycastle.crypto.digests.AsconBaseDigest;
import thirdparty.bouncycastle.util.Pack;

public class AsconCXof128
extends AsconBaseDigest
implements Xof {
    private boolean m_squeezing = false;
    private final long z0;
    private final long z1;
    private final long z2;
    private final long z3;
    private final long z4;

    public AsconCXof128() {
        this(new byte[0], 0, 0);
    }

    public AsconCXof128(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public AsconCXof128(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 > 256) {
            throw new DataLengthException("customized string is too long");
        }
        this.initState(byArray, n, n2);
        this.z0 = this.x0;
        this.z1 = this.x1;
        this.z2 = this.x2;
        this.z3 = this.x3;
        this.z4 = this.x4;
    }

    @Override
    public void update(byte by) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(byArray, n, n2);
    }

    @Override
    protected long pad(int n) {
        return 1L << (n << 3);
    }

    @Override
    protected long loadBytes(byte[] byArray, int n) {
        return Pack.littleEndianToLong(byArray, n);
    }

    @Override
    protected long loadBytes(byte[] byArray, int n, int n2) {
        return Pack.littleEndianToLong(byArray, n, n2);
    }

    @Override
    protected void setBytes(long l, byte[] byArray, int n) {
        Pack.longToLittleEndian(l, byArray, n);
    }

    @Override
    protected void setBytes(long l, byte[] byArray, int n, int n2) {
        Pack.longToLittleEndian(l, byArray, n, n2);
    }

    @Override
    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    @Override
    public String getAlgorithmName() {
        return "Ascon-CXOF128";
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        if (32 + n > byArray.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.padAndAbsorb();
        this.squeeze(byArray, n, n2);
        return n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_squeezing = false;
        this.x0 = this.z0;
        this.x1 = this.z1;
        this.x2 = this.z2;
        this.x3 = this.z3;
        this.x4 = this.z4;
    }

    private void initState(byte[] byArray, int n, int n2) {
        this.x0 = 7445901275803737603L;
        this.x1 = 4886737088792722364L;
        this.x2 = -1616759365661982283L;
        this.x3 = 3076320316797452470L;
        this.x4 = -8124743304765850554L;
        long l = (long)n2 << 3;
        Pack.longToLittleEndian(l, this.m_buf, 0);
        this.p(12);
        this.update(byArray, n, n2);
        this.padAndAbsorb();
        this.m_squeezing = false;
    }
}

